/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.algorithm;

import java.util.HashSet;
import java.util.StringJoiner;
import java.util.concurrent.atomic.DoubleAccumulator;
import org.graphstream.algorithm.APSP;
import org.graphstream.algorithm.Algorithm;
import org.graphstream.algorithm.util.Parameter;
import org.graphstream.algorithm.util.Result;
import org.graphstream.graph.Graph;

public class Eccentricity
implements Algorithm {
    protected Graph graph;
    protected String apspInfoAttribute = "APSPInfo";
    protected String eccentricityAttribute = "eccentricity";
    protected Object isInEccentricity = Boolean.TRUE;
    protected Object isNotInEccentricity = Boolean.FALSE;

    public Eccentricity() {
        this("eccentricity");
    }

    public Eccentricity(String eccentricityAttribute) {
        this(eccentricityAttribute, Boolean.TRUE, Boolean.FALSE);
    }

    public Eccentricity(String eccentricityAttribute, Object isInEccentricity, Object isNotInEccentricity) {
        this(eccentricityAttribute, Boolean.TRUE, Boolean.FALSE, "APSPInfo");
    }

    public Eccentricity(String eccentricityAttribute, Object isInEccentricity, Object isNotInEccentricity, String apspInfoAttribute) {
        this.eccentricityAttribute = eccentricityAttribute;
        this.isInEccentricity = isInEccentricity;
        this.isNotInEccentricity = isNotInEccentricity;
        this.apspInfoAttribute = apspInfoAttribute;
    }

    @Override
    public void init(Graph graph) {
        this.graph = graph;
    }

    @Override
    public void compute() {
        DoubleAccumulator min = new DoubleAccumulator((x, y) -> y, Double.MAX_VALUE);
        HashSet eccentricity = new HashSet();
        this.graph.nodes().forEach(node -> {
            DoubleAccumulator m = new DoubleAccumulator((x, y) -> y, Double.MIN_VALUE);
            APSP.APSPInfo info = (APSP.APSPInfo)node.getAttribute(this.apspInfoAttribute);
            if (info == null) {
                System.err.printf("APSPInfo missing. Did you compute APSP before ?\n", new Object[0]);
            }
            this.graph.nodes().forEach(other -> {
                if (node != other) {
                    double d = info.getLengthTo(other.getId());
                    if (d < 0.0) {
                        System.err.printf("Found a negative length value in eccentricity algorithm. Is graph connected ?\n", new Object[0]);
                    } else if (d > m.get()) {
                        m.accumulate(d);
                    }
                }
            });
            if (m.get() < min.get()) {
                eccentricity.clear();
                eccentricity.add(node);
                min.accumulate(m.get());
            } else if (m.get() == min.get()) {
                eccentricity.add(node);
            }
        });
        this.graph.nodes().forEach(node -> node.setAttribute(this.eccentricityAttribute, eccentricity.contains(node) ? this.isInEccentricity : this.isNotInEccentricity));
        eccentricity.clear();
    }

    public String getAPSPInfoAttribute() {
        return this.apspInfoAttribute;
    }

    @Parameter
    public void setAPSPInfoAttribute(String attribute) {
        this.apspInfoAttribute = attribute;
    }

    public Object getIsInEccentricityValue() {
        return this.isInEccentricity;
    }

    @Parameter
    public void setIsInEccentricityValue(Object value) {
        this.isInEccentricity = value;
    }

    public Object getIsNotInEccentricityValue() {
        return this.isNotInEccentricity;
    }

    @Parameter
    public void setIsNotInEccentricityValue(Object value) {
        this.isNotInEccentricity = value;
    }

    public String getEccentricityAttribute() {
        return this.eccentricityAttribute;
    }

    @Parameter
    public void setEccentricityAttribute(String eccentricityAttribute) {
        this.eccentricityAttribute = eccentricityAttribute;
    }

    @Result
    public String defaultResult() {
        StringJoiner sj = new StringJoiner(" | ", "====== Eccentricity ====== \n", "");
        this.graph.nodes().filter(n -> (Boolean)n.getAttribute(this.eccentricityAttribute)).forEach(n -> sj.add(n.getId()));
        return sj.toString();
    }
}

