/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.algorithm;

import java.util.HashSet;
import java.util.StringJoiner;
import java.util.concurrent.atomic.DoubleAccumulator;
import org.graphstream.algorithm.APSP;
import org.graphstream.algorithm.Algorithm;
import org.graphstream.algorithm.util.Parameter;
import org.graphstream.algorithm.util.Result;
import org.graphstream.graph.Graph;

public class Centroid
implements Algorithm {
    protected Graph graph;
    protected String apspInfoAttribute;
    protected String centroidAttribute;
    protected Object isInCentroid;
    protected Object isNotInCentroid;

    public Centroid() {
        this("centroid");
    }

    public Centroid(String centroidAttribute) {
        this(centroidAttribute, Boolean.TRUE, Boolean.FALSE);
    }

    public Centroid(String centroidAttribute, Object isInCentroid, Object isNotInCentroid) {
        this(centroidAttribute, Boolean.TRUE, Boolean.FALSE, "APSPInfo");
    }

    public Centroid(String centroidAttribute, Object isInCentroid, Object isNotInCentroid, String apspInfoAttribute) {
        this.centroidAttribute = centroidAttribute;
        this.isInCentroid = isInCentroid;
        this.isNotInCentroid = isNotInCentroid;
        this.apspInfoAttribute = apspInfoAttribute;
    }

    @Override
    public void init(Graph graph) {
        this.graph = graph;
    }

    @Override
    public void compute() {
        DoubleAccumulator min = new DoubleAccumulator((x, y) -> y, Double.MAX_VALUE);
        HashSet centroid = new HashSet();
        this.graph.nodes().forEach(node -> {
            DoubleAccumulator m = new DoubleAccumulator((x, y) -> x + y, 0.0);
            APSP.APSPInfo info = (APSP.APSPInfo)node.getAttribute(this.apspInfoAttribute);
            if (info == null) {
                System.err.printf("APSPInfo missing. Did you compute APSP before ?\n", new Object[0]);
            }
            this.graph.nodes().forEach(other -> {
                if (node != other) {
                    double d = info.getLengthTo(other.getId());
                    if (d < 0.0) {
                        System.err.printf("Found a negative length value in centroid algorithm. Is graph connected ?\n", new Object[0]);
                    } else {
                        m.accumulate(d);
                    }
                }
            });
            if (m.get() < min.get()) {
                centroid.clear();
                centroid.add(node);
                min.accumulate(m.get());
            } else if (m.get() == min.get()) {
                centroid.add(node);
            }
        });
        this.graph.nodes().forEach(node -> node.setAttribute(this.centroidAttribute, centroid.contains(node) ? this.isInCentroid : this.isNotInCentroid));
        centroid.clear();
    }

    public String getAPSPInfoAttribute() {
        return this.apspInfoAttribute;
    }

    @Parameter
    public void setAPSPInfoAttribute(String attribute) {
        this.apspInfoAttribute = attribute;
    }

    public Object getIsInCentroidValue() {
        return this.isInCentroid;
    }

    @Parameter
    public void setIsInCentroidValue(Object value) {
        this.isInCentroid = value;
    }

    public Object getIsNotInCentroidValue() {
        return this.isNotInCentroid;
    }

    @Parameter
    public void setIsNotInCentroidValue(Object value) {
        this.isNotInCentroid = value;
    }

    public String getCentroidAttribute() {
        return this.centroidAttribute;
    }

    @Parameter
    public void setCentroidAttribute(String centroidAttribute) {
        this.centroidAttribute = centroidAttribute;
    }

    @Result
    public String defaultResult() {
        StringJoiner sj = new StringJoiner(" | ", "====== Centroid ====== \n", "");
        this.graph.nodes().filter(n -> (Boolean)n.getAttribute(this.centroidAttribute)).forEach(n -> sj.add(n.getId()));
        return sj.toString();
    }
}

