/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.algorithm;

import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.concurrent.atomic.DoubleAccumulator;
import java.util.stream.Stream;
import org.graphstream.algorithm.Algorithm;
import org.graphstream.algorithm.util.Parameter;
import org.graphstream.algorithm.util.Result;
import org.graphstream.graph.Edge;
import org.graphstream.graph.Element;
import org.graphstream.graph.Graph;
import org.graphstream.graph.Node;

public class BetweennessCentrality
implements Algorithm {
    protected static double INFINITY = 1000000.0;
    protected String centralityAttributeName = "Cb";
    protected String predAttributeName = "brandes.P";
    protected String sigmaAttributeName = "brandes.sigma";
    protected String distAttributeName = "brandes.d";
    protected String deltaAttributeName = "brandes.delta";
    protected String weightAttributeName = "weight";
    protected boolean unweighted = true;
    protected Graph graph;
    protected Progress progress = null;
    protected boolean doEdges = true;

    public BetweennessCentrality() {
        this.unweighted = true;
    }

    public BetweennessCentrality(String centralityAttributeName) {
        this.centralityAttributeName = centralityAttributeName;
        this.unweighted = true;
    }

    public BetweennessCentrality(String centralityAttributeName, String weightAttributeName) {
        this.centralityAttributeName = centralityAttributeName;
        this.weightAttributeName = weightAttributeName;
        this.unweighted = false;
    }

    public String getWeightAttributeName() {
        return this.weightAttributeName;
    }

    public String getCentralityAttributeName() {
        return this.centralityAttributeName;
    }

    @Parameter
    public void setWeightAttributeName(String weightAttributeName) {
        this.unweighted = false;
        this.weightAttributeName = weightAttributeName;
    }

    public void setWeighted() {
        this.unweighted = false;
    }

    public void setUnweighted() {
        this.unweighted = true;
    }

    @Parameter
    public void computeEdgeCentrality(boolean on) {
        this.doEdges = on;
    }

    @Parameter
    public void setCentralityAttributeName(String centralityAttributeName) {
        this.centralityAttributeName = centralityAttributeName;
    }

    public void registerProgressIndicator(Progress progress) {
        this.progress = progress;
    }

    @Override
    public void init(Graph graph) {
        this.graph = graph;
    }

    @Override
    public void compute() {
        if (this.graph != null) {
            this.betweennessCentrality(this.graph);
        }
    }

    public void betweennessCentrality(Graph graph) {
        this.init(graph);
        this.initAllNodes(graph);
        this.initAllEdges(graph);
        float n = graph.getNodeCount();
        DoubleAccumulator i = new DoubleAccumulator((x, y) -> x + y, 0.0);
        graph.nodes().forEach(s -> {
            PriorityQueue<Node> S = null;
            S = this.unweighted ? this.simpleExplore((Node)s, graph) : this.dijkstraExplore2((Node)s, graph);
            while (!S.isEmpty()) {
                Node w = S.poll();
                for (Node v : this.predecessorsOf(w)) {
                    double c = this.sigma(v) / this.sigma(w) * (1.0 + this.delta(w));
                    if (this.doEdges) {
                        Edge e = w.getEdgeBetween(v);
                        this.setCentrality(e, this.centrality(e) + c);
                    }
                    this.setDelta(v, this.delta(v) + c);
                }
                if (w == s) continue;
                this.setCentrality(w, this.centrality(w) + this.delta(w));
            }
            if (this.progress != null) {
                this.progress.progress((float)i.get() / n);
            }
            i.accumulate(1.0);
        });
    }

    protected PriorityQueue<Node> simpleExplore(Node source, Graph graph) {
        LinkedList<Node> Q = new LinkedList<Node>();
        PriorityQueue<Node> S = new PriorityQueue<Node>(graph.getNodeCount(), new BrandesNodeComparatorLargerFirst());
        this.setupAllNodes(graph);
        Q.add(source);
        this.setSigma(source, 1.0);
        this.setDistance(source, 0.0);
        while (!Q.isEmpty()) {
            Node v = (Node)Q.removeFirst();
            S.add(v);
            v.leavingEdges().forEach(l -> {
                Node w = l.getOpposite(v);
                if (this.distance(w) == INFINITY) {
                    this.setDistance(w, this.distance(v) + 1.0);
                    Q.add(w);
                }
                if (this.distance(w) == this.distance(v) + 1.0) {
                    this.setSigma(w, this.sigma(w) + this.sigma(v));
                    this.addToPredecessorsOf(w, v);
                }
            });
        }
        return S;
    }

    protected PriorityQueue<Node> dijkstraExplore(Node source, Graph graph) {
        PriorityQueue<Node> S = new PriorityQueue<Node>(graph.getNodeCount(), new BrandesNodeComparatorLargerFirst());
        PriorityQueue<Node> Q = new PriorityQueue<Node>(graph.getNodeCount(), new BrandesNodeComparatorSmallerFirst());
        this.setupAllNodes(graph);
        this.setDistance(source, 0.0);
        this.setSigma(source, 1.0);
        Q.add(source);
        while (!Q.isEmpty()) {
            Node u = Q.poll();
            if (this.distance(u) < 0.0) {
                Q.clear();
                throw new RuntimeException("negative distance ??");
            }
            S.add(u);
            u.leavingEdges().forEach(l -> {
                Node v = l.getOpposite(u);
                double alt = this.distance(u) + this.weight(u, v);
                if (alt < this.distance(v)) {
                    if (this.distance(v) == INFINITY) {
                        this.setDistance(v, alt);
                        this.updatePriority(S, v);
                        this.updatePriority(Q, v);
                        Q.add(v);
                        this.setSigma(v, this.sigma(v) + this.sigma(u));
                    } else {
                        this.setDistance(v, alt);
                        this.updatePriority(S, v);
                        this.updatePriority(Q, v);
                        this.setSigma(v, this.sigma(u));
                    }
                    this.replacePredecessorsOf(v, u);
                } else if (alt == this.distance(v)) {
                    this.setSigma(v, this.sigma(v) + this.sigma(u));
                    this.addToPredecessorsOf(v, u);
                }
            });
        }
        return S;
    }

    protected PriorityQueue<Node> dijkstraExplore2(Node source, Graph graph) {
        PriorityQueue<Node> S = new PriorityQueue<Node>(graph.getNodeCount(), new BrandesNodeComparatorLargerFirst());
        PriorityQueue<Node> Q = new PriorityQueue<Node>(graph.getNodeCount(), new BrandesNodeComparatorSmallerFirst());
        this.setupAllNodes(graph);
        this.setDistance(source, 0.0);
        this.setSigma(source, 1.0);
        Q.add(source);
        while (!Q.isEmpty()) {
            Node v = Q.poll();
            S.add(v);
            v.leavingEdges().forEach(l -> {
                double dw;
                Node w = l.getOpposite(v);
                double alt = this.distance(v) + this.weight(v, w);
                if (alt < (dw = this.distance(w))) {
                    this.setDistance(w, alt);
                    this.updatePriority(S, w);
                    this.updatePriority(Q, w);
                    if (dw == INFINITY) {
                        Q.add(w);
                    }
                    this.setSigma(w, 0.0);
                    this.clearPredecessorsOf(w);
                }
                if (this.distance(w) == alt) {
                    this.setSigma(w, this.sigma(w) + this.sigma(v));
                    this.addToPredecessorsOf(w, v);
                }
            });
        }
        return S;
    }

    protected void updatePriority(PriorityQueue<Node> Q, Node node) {
        if (Q.contains(node)) {
            Q.remove(node);
            Q.add(node);
        }
    }

    protected double sigma(Node node) {
        return node.getNumber(this.sigmaAttributeName);
    }

    protected double distance(Node node) {
        return node.getNumber(this.distAttributeName);
    }

    protected double delta(Node node) {
        return node.getNumber(this.deltaAttributeName);
    }

    public double centrality(Element elt) {
        return elt.getNumber(this.centralityAttributeName);
    }

    protected Set<Node> predecessorsOf(Node node) {
        return (HashSet)node.getAttribute(this.predAttributeName);
    }

    protected void setSigma(Node node, double sigma) {
        node.setAttribute(this.sigmaAttributeName, sigma);
    }

    protected void setDistance(Node node, double distance) {
        node.setAttribute(this.distAttributeName, distance);
    }

    protected void setDelta(Node node, double delta) {
        node.setAttribute(this.deltaAttributeName, delta);
    }

    public void setCentrality(Element elt, double centrality) {
        elt.setAttribute(this.centralityAttributeName, centrality);
    }

    public void setWeight(Node from, Node to, double weight) {
        if (from.hasEdgeBetween(to.getId())) {
            from.getEdgeBetween(to.getId()).setAttribute(this.weightAttributeName, weight);
        }
    }

    public double weight(Node from, Node to) {
        Edge edge = from.getEdgeBetween(to.getId());
        if (edge != null) {
            if (edge.hasAttribute(this.weightAttributeName)) {
                return edge.getNumber(this.weightAttributeName);
            }
            return 1.0;
        }
        return 0.0;
    }

    protected void replacePredecessorsOf(Node node, Node predecessor) {
        HashSet<Node> set = new HashSet<Node>();
        set.add(predecessor);
        node.setAttribute(this.predAttributeName, set);
    }

    protected void addToPredecessorsOf(Node node, Node predecessor) {
        HashSet preds = (HashSet)node.getAttribute(this.predAttributeName);
        preds.add(predecessor);
    }

    protected void clearPredecessorsOf(Node node) {
        HashSet set = new HashSet();
        node.setAttribute(this.predAttributeName, set);
    }

    protected void initAllNodes(Graph graph) {
        graph.nodes().forEach(node -> this.setCentrality((Element)node, 0.0));
    }

    protected void initAllEdges(Graph graph) {
        if (this.doEdges) {
            graph.edges().forEach(edge -> this.setCentrality((Element)edge, 0.0));
        }
    }

    protected void setupAllNodes(Graph graph) {
        for (Node node : graph) {
            this.clearPredecessorsOf(node);
            this.setSigma(node, 0.0);
            this.setDistance(node, INFINITY);
            this.setDelta(node, 0.0);
        }
    }

    public void cleanGraph() {
        this.cleanElement(this.graph.edges());
        this.cleanElement(this.graph.nodes());
    }

    public void cleanNodes() {
        this.cleanElement(this.graph.nodes());
    }

    public void cleanEdges() {
        this.cleanElement(this.graph.edges());
    }

    private void cleanElement(Stream<? extends Element> st) {
        st.forEach(e -> {
            if (e.hasAttribute(this.predAttributeName)) {
                e.removeAttribute(this.predAttributeName);
            }
            if (e.hasAttribute(this.sigmaAttributeName)) {
                e.removeAttribute(this.sigmaAttributeName);
            }
            if (e.hasAttribute(this.distAttributeName)) {
                e.removeAttribute(this.distAttributeName);
            }
            if (e.hasAttribute(this.deltaAttributeName)) {
                e.removeAttribute(this.deltaAttributeName);
            }
        });
    }

    @Result
    public String defaultMessage() {
        return "Result stored in \"" + this.centralityAttributeName + "\" attribute";
    }

    public static interface Progress {
        public void progress(float var1);
    }

    protected class BrandesNodeComparatorSmallerFirst
    implements Comparator<Node> {
        protected BrandesNodeComparatorSmallerFirst() {
        }

        @Override
        public int compare(Node x, Node y) {
            double yy = BetweennessCentrality.this.distance(y);
            double xx = BetweennessCentrality.this.distance(x);
            if (xx > yy) {
                return 1;
            }
            if (xx < yy) {
                return -1;
            }
            return 0;
        }
    }

    protected class BrandesNodeComparatorLargerFirst
    implements Comparator<Node> {
        protected BrandesNodeComparatorLargerFirst() {
        }

        @Override
        public int compare(Node x, Node y) {
            double yy = BetweennessCentrality.this.distance(y);
            double xx = BetweennessCentrality.this.distance(x);
            if (xx > yy) {
                return -1;
            }
            if (xx < yy) {
                return 1;
            }
            return 0;
        }
    }
}

