/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.algorithm;

import java.util.ArrayList;
import java.util.List;
import org.graphstream.algorithm.Algorithm;
import org.graphstream.algorithm.util.Parameter;
import org.graphstream.algorithm.util.Result;
import org.graphstream.graph.Edge;
import org.graphstream.graph.Graph;
import org.graphstream.graph.Node;
import org.graphstream.graph.Path;

public class BellmanFord
implements Algorithm {
    protected Graph graph;
    protected String source_id;
    protected Node source;
    protected String target = "";
    protected String identifier = this.toString() + "/BellmanFord";
    protected String weightAttribute;
    public static final String DEFAULT_WEIGHT_ATTRIBUTE = "weight";

    public BellmanFord() {
        this(DEFAULT_WEIGHT_ATTRIBUTE);
    }

    public BellmanFord(String attribute) {
        this(attribute, null);
    }

    public BellmanFord(String attribute, String sourceNode) {
        this.source_id = sourceNode;
        this.weightAttribute = attribute;
    }

    @Parameter(value=true)
    public void setSource(String nodeId) {
        if (!(this.source_id != null && this.source_id.equals(nodeId) || this.graph == null)) {
            this.source = this.graph.getNode(nodeId);
        }
        this.source_id = nodeId;
    }

    @Parameter(value=true)
    public void setTarget(String target) {
        this.target = target;
    }

    @Parameter
    public void setWeightAttribute(String weightAttribute) {
        this.weightAttribute = weightAttribute;
    }

    public String getSource() {
        return this.source_id;
    }

    public List<Path> getPathSetShortestPaths(Node end) {
        ArrayList<Path> paths = new ArrayList<Path>();
        this.pathSetShortestPath_facilitate(end, new Path(), paths);
        return paths;
    }

    private void pathSetShortestPath_facilitate(Node current, Path path, List<Path> paths) {
        Node source = this.graph.getNode(this.source_id);
        if (current != source) {
            Node next = null;
            ArrayList predecessors = (ArrayList)current.getAttribute(this.identifier + ".predecessors");
            while (current != source && predecessors.size() == 1) {
                Edge e2 = (Edge)predecessors.get(0);
                next = e2.getOpposite(current);
                path.add(current, e2);
                current = next;
                predecessors = (ArrayList)current.getAttribute(this.identifier + ".predecessors");
            }
            if (current != source) {
                Node c = current;
                predecessors.forEach(e -> {
                    Path p = path.getACopy();
                    p.add(c, (Edge)e);
                    this.pathSetShortestPath_facilitate(e.getOpposite(c), p, paths);
                });
            }
        }
        if (current == source) {
            paths.add(path);
        }
    }

    @Override
    public void init(Graph graph) {
        this.graph = graph;
        if (this.getSource() != null) {
            this.source = graph.getNode(this.getSource());
        }
    }

    @Parameter
    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public double getShortestPathValue(Node target) {
        Double d = (double)((Double)target.getAttribute(this.identifier + ".distance"));
        if (d != null) {
            return d;
        }
        return Double.POSITIVE_INFINITY;
    }

    public Path getShortestPath(Node target) {
        Path p = new Path();
        if (target == this.source) {
            return p;
        }
        boolean noPath = false;
        Node v = target;
        while (v != this.source && !noPath) {
            ArrayList list = (ArrayList)v.getAttribute(this.identifier + ".predecessors");
            if (list == null) {
                noPath = true;
                continue;
            }
            Edge parentEdge = (Edge)list.get(0);
            p.add(v, parentEdge);
            v = parentEdge.getOpposite(v);
        }
        return p;
    }

    public Path getShortestPath() {
        return this.getShortestPath(this.graph.getNode(this.target));
    }

    @Result
    public String defaultResult() {
        return this.getShortestPath().toString();
    }

    @Override
    public void compute() {
        Node source = this.graph.getNode(this.source_id);
        this.graph.nodes().forEach(n -> {
            if (n == source) {
                n.setAttribute(this.identifier + ".distance", 0.0);
            } else {
                n.setAttribute(this.identifier + ".distance", Double.POSITIVE_INFINITY);
            }
        });
        this.graph.nodes().forEach(n -> this.graph.edges().forEach(e -> {
            Node n0 = e.getNode0();
            Node n1 = e.getNode1();
            Double d0 = (Double)n0.getAttribute(this.identifier + ".distance");
            Double d1 = (Double)n1.getAttribute(this.identifier + ".distance");
            Double we = (Double)e.getAttribute(this.weightAttribute);
            if (we == null) {
                throw new NumberFormatException("org.graphstream.algorithm.BellmanFord: Problem with attribute \"" + this.weightAttribute + "\" on edge " + e);
            }
            if (d0 != null && (d1 == null || d1 >= d0 + we)) {
                n1.setAttribute(this.identifier + ".distance", d0 + we);
                ArrayList<Edge> predecessors = (ArrayList<Edge>)n1.getAttribute(this.identifier + ".predecessors");
                if (d1 != null && d1 == d0 + we) {
                    if (predecessors == null) {
                        predecessors = new ArrayList();
                    }
                } else {
                    predecessors = new ArrayList<Edge>();
                }
                if (!predecessors.contains(e)) {
                    predecessors.add((Edge)e);
                }
                n1.setAttribute(this.identifier + ".predecessors", predecessors);
            }
        }));
        this.graph.edges().forEach(e -> {
            Node n0 = e.getNode0();
            Node n1 = e.getNode1();
            Double d0 = (Double)n0.getAttribute(this.identifier + ".distance");
            Double d1 = (Double)n1.getAttribute(this.identifier + ".distance");
            Double we = (Double)e.getAttribute(this.weightAttribute);
            if (we == null) {
                throw new NumberFormatException(String.format("%s: Problem with attribute \"%s\" on edge \"%s\"", BellmanFord.class.getName(), this.weightAttribute, e.getId()));
            }
            if (d1 > d0 + we) {
                throw new NumberFormatException(String.format("%s: Problem: negative weight, cycle detected on edge \"%s\"", BellmanFord.class.getName(), e.getId()));
            }
        });
    }
}

