/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.stat.descriptive.moment;

import java.io.Serializable;
import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.stat.descriptive.AbstractUnivariateStatistic;
import org.apache.commons.math.stat.descriptive.moment.Mean;

public class SemiVariance
extends AbstractUnivariateStatistic
implements Serializable {
    public static final Direction UPSIDE_VARIANCE = Direction.UPSIDE;
    public static final Direction DOWNSIDE_VARIANCE = Direction.DOWNSIDE;
    private static final long serialVersionUID = -2653430366886024994L;
    private boolean biasCorrected = true;
    private Direction varianceDirection = Direction.DOWNSIDE;

    public SemiVariance() {
    }

    public SemiVariance(boolean biasCorrected) {
        this.biasCorrected = biasCorrected;
    }

    public SemiVariance(Direction direction) {
        this.varianceDirection = direction;
    }

    public SemiVariance(boolean corrected, Direction direction) {
        this.biasCorrected = corrected;
        this.varianceDirection = direction;
    }

    public SemiVariance(SemiVariance original) {
        SemiVariance.copy(original, this);
    }

    public SemiVariance copy() {
        SemiVariance result = new SemiVariance();
        SemiVariance.copy(this, result);
        return result;
    }

    public static void copy(SemiVariance source, SemiVariance dest) {
        dest.biasCorrected = source.biasCorrected;
        dest.varianceDirection = source.varianceDirection;
    }

    public double evaluate(double[] values2) {
        if (values2 == null) {
            throw MathRuntimeException.createIllegalArgumentException("input values array is null", new Object[0]);
        }
        return this.evaluate(values2, 0, values2.length);
    }

    public double evaluate(double[] values2, int start, int length) {
        double m = new Mean().evaluate(values2, start, length);
        return this.evaluate(values2, m, this.varianceDirection, this.biasCorrected, 0, values2.length);
    }

    public double evaluate(double[] values2, Direction direction) {
        double m = new Mean().evaluate(values2);
        return this.evaluate(values2, m, direction, this.biasCorrected, 0, values2.length);
    }

    public double evaluate(double[] values2, double cutoff) {
        return this.evaluate(values2, cutoff, this.varianceDirection, this.biasCorrected, 0, values2.length);
    }

    public double evaluate(double[] values2, double cutoff, Direction direction) {
        return this.evaluate(values2, cutoff, direction, this.biasCorrected, 0, values2.length);
    }

    public double evaluate(double[] values2, double cutoff, Direction direction, boolean corrected, int start, int length) {
        this.test(values2, start, length);
        if (values2.length == 0) {
            return Double.NaN;
        }
        if (values2.length == 1) {
            return 0.0;
        }
        boolean booleanDirection = direction.getDirection();
        double dev = 0.0;
        double sumsq = 0.0;
        for (int i = start; i < length; ++i) {
            if (values2[i] > cutoff != booleanDirection) continue;
            dev = values2[i] - cutoff;
            sumsq += dev * dev;
        }
        if (corrected) {
            return sumsq / ((double)length - 1.0);
        }
        return sumsq / (double)length;
    }

    public boolean isBiasCorrected() {
        return this.biasCorrected;
    }

    public void setBiasCorrected(boolean biasCorrected) {
        this.biasCorrected = biasCorrected;
    }

    public Direction getVarianceDirection() {
        return this.varianceDirection;
    }

    public void setVarianceDirection(Direction varianceDirection) {
        this.varianceDirection = varianceDirection;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Direction {
        UPSIDE(true),
        DOWNSIDE(false);

        private boolean direction;

        private Direction(boolean b) {
            this.direction = b;
        }

        boolean getDirection() {
            return this.direction;
        }
    }
}

