/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.stat.descriptive;

import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.stat.descriptive.AbstractUnivariateStatistic;
import org.apache.commons.math.stat.descriptive.StorelessUnivariateStatistic;
import org.apache.commons.math.util.MathUtils;

public abstract class AbstractStorelessUnivariateStatistic
extends AbstractUnivariateStatistic
implements StorelessUnivariateStatistic {
    public double evaluate(double[] values2) {
        if (values2 == null) {
            throw MathRuntimeException.createIllegalArgumentException("input values array is null", new Object[0]);
        }
        return this.evaluate(values2, 0, values2.length);
    }

    public double evaluate(double[] values2, int begin, int length) {
        if (this.test(values2, begin, length)) {
            this.clear();
            this.incrementAll(values2, begin, length);
        }
        return this.getResult();
    }

    public abstract StorelessUnivariateStatistic copy();

    public abstract void clear();

    public abstract double getResult();

    public abstract void increment(double var1);

    public void incrementAll(double[] values2) {
        if (values2 == null) {
            throw MathRuntimeException.createIllegalArgumentException("input values array is null", new Object[0]);
        }
        this.incrementAll(values2, 0, values2.length);
    }

    public void incrementAll(double[] values2, int begin, int length) {
        if (this.test(values2, begin, length)) {
            int k = begin + length;
            for (int i = begin; i < k; ++i) {
                this.increment(values2[i]);
            }
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof AbstractStorelessUnivariateStatistic)) {
            return false;
        }
        AbstractStorelessUnivariateStatistic stat = (AbstractStorelessUnivariateStatistic)object;
        return MathUtils.equals(stat.getResult(), this.getResult()) && MathUtils.equals(stat.getN(), this.getN());
    }

    public int hashCode() {
        return 31 * (31 + MathUtils.hash(this.getResult())) + MathUtils.hash(this.getN());
    }
}

