/*
 * Decompiled with CFR 0.152.
 */
package hu.unideb.inf.dina.v2.model;

import hu.unideb.inf.dina.commons.model.Vertex;
import hu.unideb.inf.dina.v2.model.EdgeType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class TrinodeJunction {
    private final Vertex centerVertex;
    private final Vertex vertexA;
    private final Vertex vertexC;
    private TrinodeJunctionType type;

    public TrinodeJunction(Vertex centerVertex, Vertex vertexA, Vertex vertexC) {
        this.centerVertex = centerVertex;
        this.vertexA = vertexA;
        this.vertexC = vertexC;
    }

    public TrinodeJunctionType getType() {
        return this.type;
    }

    public void calculateType() {
        EdgeType aToB = EdgeType.fromVertices(this.vertexA, this.centerVertex);
        EdgeType bToC = EdgeType.fromVertices(this.centerVertex, this.vertexC);
        this.type = aToB == EdgeType.INOUT && bToC == EdgeType.INOUT ? TrinodeJunctionType.TYPE_1 : (aToB == EdgeType.INOUT && bToC == EdgeType.OUT || aToB == EdgeType.IN && bToC == EdgeType.INOUT ? TrinodeJunctionType.TYPE_2 : (aToB == EdgeType.INOUT && bToC == EdgeType.IN || aToB == EdgeType.OUT && bToC == EdgeType.INOUT ? TrinodeJunctionType.TYPE_3 : (aToB == EdgeType.OUT && bToC == EdgeType.OUT || aToB == EdgeType.IN && bToC == EdgeType.IN ? TrinodeJunctionType.TYPE_4 : (aToB == EdgeType.IN && bToC == EdgeType.OUT ? TrinodeJunctionType.TYPE_5 : TrinodeJunctionType.TYPE_6))));
    }

    public int hashCode() {
        return this.vertexA.getId() & this.centerVertex.getId() & this.vertexC.getId();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TrinodeJunction)) {
            return false;
        }
        TrinodeJunction objTrinode = (TrinodeJunction)obj;
        ArrayList<Vertex> thisVertices = new ArrayList<Vertex>(List.of(this.vertexA, this.centerVertex, this.vertexC));
        ArrayList<Vertex> objVertices = new ArrayList<Vertex>(List.of(objTrinode.vertexA, objTrinode.centerVertex, objTrinode.vertexC));
        Collections.sort(thisVertices);
        Collections.sort(objVertices);
        return thisVertices.equals(objVertices);
    }

    public String toString() {
        ArrayList<Vertex> vertices = new ArrayList<Vertex>(List.of(this.vertexA, this.centerVertex, this.vertexC));
        Collections.sort(vertices);
        return String.format("%d (%d, %d, %d)", this.type.ordinal() + 1, vertices.get(0).getId(), vertices.get(1).getId(), vertices.get(2).getId());
    }

    public static enum TrinodeJunctionType {
        TYPE_1,
        TYPE_2,
        TYPE_3,
        TYPE_4,
        TYPE_5,
        TYPE_6;

    }
}

