/*
 * Decompiled with CFR 0.152.
 */
package hu.unideb.inf.dina.v2.model;

import hu.unideb.inf.dina.commons.model.Vertex;
import hu.unideb.inf.dina.v2.model.EdgeType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Triangle {
    private final Vertex vertexA;
    private final Vertex vertexB;
    private final Vertex vertexC;
    private TriangleType type;

    public Triangle(Vertex vertexA, Vertex vertexB, Vertex vertexC) {
        this.vertexA = vertexA;
        this.vertexB = vertexB;
        this.vertexC = vertexC;
    }

    public TriangleType getType() {
        return this.type;
    }

    public void calculateType() {
        EdgeType aToB = EdgeType.fromVertices(this.vertexA, this.vertexB);
        EdgeType bToC = EdgeType.fromVertices(this.vertexB, this.vertexC);
        EdgeType cToA = EdgeType.fromVertices(this.vertexC, this.vertexA);
        this.type = aToB == EdgeType.INOUT && bToC == EdgeType.INOUT && cToA == EdgeType.INOUT ? TriangleType.TYPE_1 : (aToB == EdgeType.INOUT && bToC == EdgeType.INOUT || aToB == EdgeType.INOUT && cToA == EdgeType.INOUT || bToC == EdgeType.INOUT && cToA == EdgeType.INOUT ? TriangleType.TYPE_2 : (aToB == EdgeType.INOUT && bToC == EdgeType.OUT && cToA == EdgeType.IN || bToC == EdgeType.INOUT && cToA == EdgeType.OUT && aToB == EdgeType.IN || cToA == EdgeType.INOUT && aToB == EdgeType.OUT && bToC == EdgeType.IN ? TriangleType.TYPE_3 : (aToB == EdgeType.INOUT && bToC == EdgeType.IN && cToA == EdgeType.OUT || bToC == EdgeType.INOUT && cToA == EdgeType.IN && aToB == EdgeType.OUT || cToA == EdgeType.INOUT && aToB == EdgeType.IN && bToC == EdgeType.OUT ? TriangleType.TYPE_4 : (aToB == EdgeType.INOUT && bToC == cToA || bToC == EdgeType.INOUT && cToA == aToB || cToA == EdgeType.INOUT && aToB == bToC ? TriangleType.TYPE_5 : (aToB == bToC && bToC == cToA ? TriangleType.TYPE_6 : TriangleType.TYPE_7)))));
    }

    public int hashCode() {
        return this.vertexA.getId() & this.vertexB.getId() & this.vertexC.getId();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Triangle)) {
            return false;
        }
        Triangle objTriangle = (Triangle)obj;
        ArrayList<Vertex> thisVertices = new ArrayList<Vertex>(List.of(this.vertexA, this.vertexB, this.vertexC));
        ArrayList<Vertex> objVertices = new ArrayList<Vertex>(List.of(objTriangle.vertexA, objTriangle.vertexB, objTriangle.vertexC));
        Collections.sort(thisVertices);
        Collections.sort(objVertices);
        return thisVertices.equals(objVertices);
    }

    public String toString() {
        ArrayList<Vertex> vertices = new ArrayList<Vertex>(List.of(this.vertexA, this.vertexB, this.vertexC));
        Collections.sort(vertices);
        return String.format("%d (%d, %d, %d)", this.type.ordinal() + 1, vertices.get(0).getId(), vertices.get(1).getId(), vertices.get(2).getId());
    }

    public Triangle(Vertex vertexA, Vertex vertexB, Vertex vertexC, TriangleType type) {
        this.vertexA = vertexA;
        this.vertexB = vertexB;
        this.vertexC = vertexC;
        this.type = type;
    }

    public static enum TriangleType {
        TYPE_1,
        TYPE_2,
        TYPE_3,
        TYPE_4,
        TYPE_5,
        TYPE_6,
        TYPE_7;

    }
}

