/*
 * Decompiled with CFR 0.152.
 */
package hu.unideb.inf.dina.v2.algorithms;

import hu.unideb.inf.dina.commons.analysis.GraphAnalyzer;
import hu.unideb.inf.dina.commons.model.Graph;
import hu.unideb.inf.dina.commons.model.Vertex;
import hu.unideb.inf.dina.commons.result.AnalysisResult;
import hu.unideb.inf.dina.commons.result.FileResult;
import hu.unideb.inf.dina.commons.result.TableResult;
import hu.unideb.inf.dina.v2.algorithms.Tarjan;
import hu.unideb.inf.dina.v2.utils.DescriptionReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class Tendril
implements GraphAnalyzer {
    private static final String TENDRIL_TABLE_LAYER = "Layer";
    private static final String TENDRIL_TABLE_IN = "In";
    private static final String TENDRIL_TABLE_IN_OUT = "In Out";
    private static final String TENDRIL_TABLE_OUT = "Out";
    private FileResult fileResult = new FileResult();

    @Override
    public Collection<AnalysisResult<?>> analyze(Graph graph) {
        graph.getGraph().values().forEach(v -> {
            v.getProperties().put("type", (Object)Type.UNDEFINED);
            v.getProperties().put("layer", -1);
        });
        Tarjan tarjan = new Tarjan();
        tarjan.analyze(graph);
        List<Vertex> inOut = tarjan.getGs();
        ArrayList<Vertex> in = new ArrayList<Vertex>();
        ArrayList<Vertex> out = new ArrayList<Vertex>();
        int layerNum = 0;
        for (Vertex vertex : inOut) {
            vertex.getProperties().put("layer", layerNum);
            vertex.getProperties().put("type", (Object)Type.INOUT);
        }
        do {
            inOut.addAll(in);
            inOut.addAll(out);
            in.clear();
            out.clear();
            this.findGinIterative(inOut, in, layerNum);
            this.findGoutIterative(inOut, out, layerNum);
            in.forEach(v -> {
                if (out.contains(v)) {
                    v.getProperties().put("type", (Object)Type.INOUT);
                }
            });
            ++layerNum;
        } while (!in.isEmpty() || !out.isEmpty());
        ArrayList elementsIn = new ArrayList();
        ArrayList elementsInOut = new ArrayList();
        ArrayList elementsOut = new ArrayList();
        for (int i = 0; i < layerNum - 1; ++i) {
            elementsIn.add(new ArrayList());
            elementsInOut.add(new ArrayList());
            elementsOut.add(new ArrayList());
        }
        for (Vertex v2 : graph.getGraph().values()) {
            switch ((Type)((Object)v2.getProperties().get("type"))) {
                case IN: {
                    ((List)elementsIn.get((Integer)v2.getProperties().get("layer"))).add(v2.getId());
                    break;
                }
                case OUT: {
                    ((List)elementsOut.get((Integer)v2.getProperties().get("layer"))).add(v2.getId());
                    break;
                }
                case INOUT: {
                    ((List)elementsInOut.get((Integer)v2.getProperties().get("layer"))).add(v2.getId());
                }
            }
        }
        TableResult tableResult = new TableResult();
        tableResult.addHeader(List.of(TENDRIL_TABLE_LAYER, TENDRIL_TABLE_IN, TENDRIL_TABLE_IN_OUT, TENDRIL_TABLE_OUT));
        for (int i = 0; i < layerNum - 1; ++i) {
            tableResult.addRow(List.of(Integer.toString(i), this.elementListToString((List)elementsIn.get(i)), this.elementListToString((List)elementsInOut.get(i)), this.elementListToString((List)elementsOut.get(i))));
        }
        FileResult fileResult = FileResult.fromTableResult("tendril", tableResult);
        return List.of(tableResult, fileResult);
    }

    @Override
    public String getName() {
        return "Tendril";
    }

    @Override
    public String getDescription() {
        return Objects.requireNonNull(DescriptionReader.readDescriptionFromFile("tendril.html"));
    }

    private void findGinIterative(List<Vertex> inOut, List<Vertex> in, int layerNum) {
        ArrayList<Vertex> nodesToProcess = new ArrayList<Vertex>();
        inOut.forEach(vertex -> this.addInAdjacentsToProcessList((Vertex)vertex, (List<Vertex>)nodesToProcess, layerNum));
        while (!nodesToProcess.isEmpty()) {
            Vertex v = (Vertex)nodesToProcess.remove(0);
            this.addInAdjacentsToProcessList(v, nodesToProcess, layerNum);
            in.add(v);
            v.getProperties().put("layer", layerNum);
        }
    }

    private void findGoutIterative(List<Vertex> inOut, List<Vertex> out, int layerNum) {
        ArrayList<Vertex> nodesToProcess = new ArrayList<Vertex>();
        inOut.forEach(vertex -> this.addOutAdjacentsToProcessList((Vertex)vertex, (List<Vertex>)nodesToProcess, layerNum));
        while (!nodesToProcess.isEmpty()) {
            Vertex v = (Vertex)nodesToProcess.remove(0);
            this.addOutAdjacentsToProcessList(v, nodesToProcess, layerNum);
            out.add(v);
            v.getProperties().put("layer", layerNum);
        }
    }

    private void addInAdjacentsToProcessList(Vertex v, List<Vertex> nodesToProcess, int layerNum) {
        v.getInAdjacents().forEach(vin -> {
            if (vin.getProperties().get("type") == Type.UNDEFINED) {
                vin.getProperties().put("type", (Object)Type.IN);
                nodesToProcess.add((Vertex)vin);
            } else if (vin.getProperties().get("type") == Type.OUT && (Integer)vin.getProperties().get("layer") == layerNum) {
                vin.getProperties().put("type", (Object)Type.INOUT);
                nodesToProcess.add((Vertex)vin);
            }
        });
    }

    private void addOutAdjacentsToProcessList(Vertex v, List<Vertex> nodesToProcess, int layerNum) {
        v.getOutAdjacents().forEach(vout -> {
            if (vout.getProperties().get("type") == Type.UNDEFINED) {
                vout.getProperties().put("type", (Object)Type.OUT);
                nodesToProcess.add((Vertex)vout);
            } else if (vout.getProperties().get("type") == Type.IN && (Integer)vout.getProperties().get("layer") == layerNum) {
                vout.getProperties().put("type", (Object)Type.INOUT);
                nodesToProcess.add((Vertex)vout);
            }
        });
    }

    private String elementListToString(List<Integer> elements) {
        return elements.size() + "(" + String.join((CharSequence)",", elements.stream().map(Object::toString).collect(Collectors.toList())) + ")";
    }

    public static enum Type {
        IN,
        OUT,
        INOUT,
        UNDEFINED;

    }
}

