/*
 * Decompiled with CFR 0.152.
 */
package hu.unideb.inf.dina.v2.algorithms;

import hu.unideb.inf.dina.commons.analysis.GraphAnalyzer;
import hu.unideb.inf.dina.commons.model.Graph;
import hu.unideb.inf.dina.commons.model.Vertex;
import hu.unideb.inf.dina.commons.result.AnalysisResult;
import hu.unideb.inf.dina.commons.result.FileResult;
import hu.unideb.inf.dina.commons.result.MapResult;
import hu.unideb.inf.dina.commons.result.TableResult;
import hu.unideb.inf.dina.v2.utils.DescriptionReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Stack;
import java.util.stream.Collectors;

public class Tarjan
implements GraphAnalyzer {
    private static final String TARJAN_NUMBER_OF_NODES = "# of nodes";
    private static final String TARJAN_NUMBER_OF_COMPONENTS = "# of components";
    private static final String TARJAN_BIGGEST_COMPONENT_SIZE = "Size of the biggest component";
    private static final String TARJAN_TABLE_COMPONENT_NUM = "Component num";
    private static final String TARJAN_TABLE_SIZE = "Size";
    private List<List<Vertex>> scc = new ArrayList<List<Vertex>>();
    private Stack<Vertex> stack = new Stack();
    private FileResult fileResult = new FileResult();

    @Override
    public Collection<AnalysisResult<?>> analyze(Graph graph) {
        graph.getGraph().values().forEach(v -> {
            v.getProperties().put("index", -1);
            v.getProperties().put("lowlink", -1);
            v.getProperties().put("caller", null);
            v.getProperties().put("adjIdx", 0);
        });
        graph.getGraph().values().forEach(v -> {
            if ((Integer)v.getProperties().get("index") < 0) {
                this.strongConnect((Vertex)v);
            }
        });
        MapResult mapResult = new MapResult();
        mapResult.getResult().put(TARJAN_NUMBER_OF_NODES, Integer.toString(graph.getGraph().values().size()));
        mapResult.getResult().put(TARJAN_NUMBER_OF_COMPONENTS, Integer.toString(this.scc.size()));
        mapResult.getResult().put(TARJAN_BIGGEST_COMPONENT_SIZE, ((Integer)this.scc.stream().map(List::size).sorted(Comparator.reverseOrder()).collect(Collectors.toList()).get(0)).toString());
        TableResult tableResult = TableResult.fromList(List.of(TARJAN_TABLE_COMPONENT_NUM, TARJAN_TABLE_SIZE), this.scc);
        FileResult fileResult = FileResult.fromTableResult("tarjan", tableResult);
        return List.of(mapResult, tableResult, fileResult);
    }

    @Override
    public String getName() {
        return "Tarjan";
    }

    @Override
    public String getDescription() {
        return Objects.requireNonNull(DescriptionReader.readDescriptionFromFile("tarjan.html"));
    }

    public List<Vertex> getGs() {
        List<Vertex> gs = null;
        for (List<Vertex> component : this.scc) {
            if (gs == null) {
                gs = component;
                continue;
            }
            if (component.size() <= gs.size()) continue;
            gs = component;
        }
        return gs;
    }

    private void strongConnect(Vertex vertex) {
        int index = 0;
        vertex.getProperties().put("index", index);
        vertex.getProperties().put("lowlink", index);
        ++index;
        this.stack.push(vertex);
        Vertex last = vertex;
        while (true) {
            Vertex newLast;
            Integer adjIdx;
            if ((adjIdx = (Integer)last.getProperties().get("adjIdx")) < last.getOutAdjacents().size()) {
                Vertex w = last.getOutAdjacents().get(adjIdx);
                adjIdx = adjIdx + 1;
                last.getProperties().put("adjIdx", adjIdx);
                if ((Integer)w.getProperties().get("index") == -1) {
                    w.getProperties().put("caller", last);
                    w.getProperties().put("index", index);
                    w.getProperties().put("lowlink", index);
                    ++index;
                    this.stack.push(w);
                    last = w;
                    continue;
                }
                if (!this.stack.contains(w)) continue;
                last.getProperties().put("lowlink", Math.min((Integer)last.getProperties().get("lowlink"), (Integer)w.getProperties().get("index")));
                continue;
            }
            if (last.getProperties().get("lowlink").equals(last.getProperties().get("index"))) {
                ArrayList<Vertex> vertices = new ArrayList<Vertex>();
                Vertex top = this.stack.pop();
                vertices.add(top);
                while (!top.equals(last)) {
                    top = this.stack.pop();
                    vertices.add(top);
                }
                this.scc.add(vertices);
            }
            if ((newLast = (Vertex)last.getProperties().get("caller")) == null) break;
            newLast.getProperties().put("lowlink", Math.min((Integer)newLast.getProperties().get("lowlink"), (Integer)last.getProperties().get("lowlink")));
            last = newLast;
        }
    }
}

