/*
 * Decompiled with CFR 0.152.
 */
package hu.unideb.inf.dina.v2.algorithms;

import hu.unideb.inf.dina.commons.analysis.GraphAnalyzer;
import hu.unideb.inf.dina.commons.model.Graph;
import hu.unideb.inf.dina.commons.model.LineChartDataSet;
import hu.unideb.inf.dina.commons.model.Vertex;
import hu.unideb.inf.dina.commons.result.AnalysisResult;
import hu.unideb.inf.dina.commons.result.FileResult;
import hu.unideb.inf.dina.commons.result.LineChartResult;
import hu.unideb.inf.dina.commons.result.MapResult;
import hu.unideb.inf.dina.v2.utils.DescriptionReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class SimpleStatistics
implements GraphAnalyzer {
    private static final String STATS_NODE_NUM = "# of nodes";
    private static final String STATS_LINK_NUM = "# of links";
    private static final String STATS_SELF_LOOP_NUM = "# of self loops";
    private static final String STATS_UNIDIR_LINK_NUM = "# of unidirectional links";
    private static final String STATS_BIDIR_LINK_NUM = "# of bidirectional links";
    private static final String STATS_MULTI_LINK_NUM = "# of multilinks";
    private Graph graph;
    private MapResult mapResult = new MapResult();
    private LineChartResult lineChartResult = new LineChartResult();
    private FileResult inDegreeFileResult = new FileResult();
    private FileResult outDegreeFileResult = new FileResult();

    @Override
    public Collection<AnalysisResult<?>> analyze(Graph graph) {
        this.graph = graph;
        this.calculateLinkStatistics();
        this.calculateDegreeDistribution();
        this.lineChartResult.getLineChart().setTitle("Degree distribution");
        return List.of(this.mapResult, this.lineChartResult, this.inDegreeFileResult, this.outDegreeFileResult);
    }

    @Override
    public String getName() {
        return "Simple graph statistics";
    }

    @Override
    public String getDescription() {
        return Objects.requireNonNull(DescriptionReader.readDescriptionFromFile("simple-statistics.html"));
    }

    private void calculateLinkStatistics() {
        int unidirLinkNum = 0;
        int bidirLinkNum = 0;
        int selfLoopNum = 0;
        int multilinkNum = 0;
        HashMap<Vertex, Integer> multiEdges = new HashMap<Vertex, Integer>();
        for (Vertex v2 : this.graph.getGraph().values()) {
            multiEdges.clear();
            for (Vertex out : v2.getOutAdjacents()) {
                if (multiEdges.containsKey(out)) {
                    int multiCount = (Integer)multiEdges.get(out);
                    if (multiCount == 1) {
                        ++multilinkNum;
                    }
                    multiEdges.put(out, multiCount + 1);
                    continue;
                }
                multiEdges.put(out, 1);
                if (v2.equals(out)) {
                    ++selfLoopNum;
                    continue;
                }
                if (v2.getInAdjacents().contains(out)) {
                    ++bidirLinkNum;
                    continue;
                }
                ++unidirLinkNum;
            }
        }
        bidirLinkNum /= 2;
        this.mapResult.getResult().put(STATS_NODE_NUM, Integer.toString(this.graph.getGraph().values().size()));
        this.mapResult.getResult().put(STATS_LINK_NUM, Integer.toString(this.graph.getGraph().values().stream().mapToInt(v -> v.getOutAdjacents().size()).sum()));
        this.mapResult.getResult().put(STATS_SELF_LOOP_NUM, Integer.toString(selfLoopNum));
        this.mapResult.getResult().put(STATS_UNIDIR_LINK_NUM, Integer.toString(unidirLinkNum));
        this.mapResult.getResult().put(STATS_BIDIR_LINK_NUM, Integer.toString(bidirLinkNum));
        this.mapResult.getResult().put(STATS_MULTI_LINK_NUM, Integer.toString(multilinkNum));
    }

    private void calculateDegreeDistribution() {
        ArrayList<Integer> inDegDist = new ArrayList<Integer>();
        ArrayList<Integer> outDegDist = new ArrayList<Integer>();
        for (Vertex v : this.graph.getGraph().values()) {
            int inCount = v.getInAdjacents().size();
            int inN = inCount - inDegDist.size() + 1;
            if (inN > 0) {
                inDegDist.addAll(Collections.nCopies(inN, 0));
            }
            inDegDist.set(inCount, (Integer)inDegDist.get(inCount) + 1);
            int outCount = v.getOutAdjacents().size();
            int outN = outCount - outDegDist.size() + 1;
            if (outN > 0) {
                outDegDist.addAll(Collections.nCopies(outN, 0));
            }
            outDegDist.set(outCount, (Integer)outDegDist.get(outCount) + 1);
        }
        int numberOfNodes = this.graph.getGraph().values().size();
        List inDegreeHorizontal = IntStream.range(0, inDegDist.size()).boxed().collect(Collectors.toList());
        List inDegreeVertical = inDegDist.stream().map(integer -> (double)integer.intValue() / (double)numberOfNodes).collect(Collectors.toList());
        this.lineChartResult.getLineChart().getDataSets().add(new LineChartDataSet("In-degree", inDegreeVertical, inDegreeHorizontal));
        this.inDegreeFileResult.setFileName("in-degree");
        for (int i = 0; i < inDegreeHorizontal.size(); ++i) {
            this.inDegreeFileResult.addLine(String.join((CharSequence)";", ((Integer)inDegreeHorizontal.get(i)).toString(), ((Double)inDegreeVertical.get(i)).toString()));
        }
        List outDegreeHorizontal = IntStream.range(0, outDegDist.size()).boxed().collect(Collectors.toList());
        List outDegreeVertical = outDegDist.stream().map(integer -> (double)integer.intValue() / (double)numberOfNodes).collect(Collectors.toList());
        this.lineChartResult.getLineChart().getDataSets().add(new LineChartDataSet("Out-degree", outDegreeVertical, outDegreeHorizontal));
        this.outDegreeFileResult.setFileName("out-degree");
        for (int i = 0; i < outDegreeHorizontal.size(); ++i) {
            this.outDegreeFileResult.addLine(String.join((CharSequence)";", ((Integer)outDegreeHorizontal.get(i)).toString(), ((Double)outDegreeVertical.get(i)).toString()));
        }
    }
}

