/*
 * Decompiled with CFR 0.152.
 */
package hu.unideb.inf.dina.v2;

import hu.unideb.inf.dina.commons.analysis.GraphAnalyzer;
import hu.unideb.inf.dina.commons.analysis.GraphAnalyzerDiscoverer;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.reflections.Reflections;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;

public class GraphAnalyzerAdapter
implements GraphAnalyzerDiscoverer {
    private Reflections ref;

    @Override
    public void init(@NotNull ClassLoader classLoader) {
        ConfigurationBuilder configurationBuilder = new ConfigurationBuilder().setUrls(ClasspathHelper.forPackage("hu.unideb.inf.dina.v2.algorithms", classLoader)).setScanners(new SubTypesScanner(false));
        configurationBuilder.addClassLoader(classLoader);
        this.ref = new Reflections(configurationBuilder);
    }

    @Override
    @NotNull
    public List<GraphAnalyzer> getGraphAnalyzers() {
        return this.getGraphAnalyzerClasses().stream().map(this::createInstance).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    @NotNull
    public GraphAnalyzer getGraphAnalyzer(@NotNull String id) {
        return this.getGraphAnalyzerClasses().stream().filter(clazz -> clazz.getName().equals(id)).findFirst().map(this::createInstance).orElseThrow(RuntimeException::new);
    }

    private Set<Class<? extends GraphAnalyzer>> getGraphAnalyzerClasses() {
        return this.ref.getSubTypesOf(GraphAnalyzer.class);
    }

    private GraphAnalyzer createInstance(Class<? extends GraphAnalyzer> clazz) {
        return Stream.of(clazz.getDeclaredConstructors()).filter(constructor -> constructor.getParameterCount() == 0).findFirst().map(constructor -> {
            try {
                return (GraphAnalyzer)constructor.newInstance(new Object[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }).orElseThrow(RuntimeException::new);
    }
}

