/*
 * Decompiled with CFR 0.152.
 */
package hu.unideb.inf.dina;

import hu.unideb.inf.dina.commons.exception.GraphReaderException;
import hu.unideb.inf.dina.commons.model.Graph;
import hu.unideb.inf.dina.commons.model.Vertex;
import hu.unideb.inf.dina.commons.reader.FileGraphReader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Scanner;
import java.util.logging.Level;
import java.util.logging.Logger;

public class VertexPairGraphReader
extends FileGraphReader {
    private boolean allVerticesPreAdded;

    @Override
    public void readGraphFromInputStream(InputStream inputStream, Graph graph) throws GraphReaderException {
        graph.getGraph().clear();
        this.allVerticesPreAdded = false;
        try (InputStreamReader isr = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
             BufferedReader in = new BufferedReader(isr);){
            String line;
            String firstLine = in.readLine();
            try {
                long vertexNum = Integer.parseInt(firstLine);
                int i = 0;
                while ((long)i < vertexNum) {
                    graph.add(new Vertex(i));
                    ++i;
                }
                this.allVerticesPreAdded = true;
            }
            catch (NumberFormatException e) {
                this.processLine(firstLine, graph);
            }
            while ((line = in.readLine()) != null) {
                this.processLine(line, graph);
            }
        }
        catch (IOException ex) {
            Logger.getLogger(VertexPairGraphReader.class.getName()).log(Level.SEVERE, null, ex);
            throw new GraphReaderException("Invalid file format");
        }
    }

    private void processLine(String line, Graph g) throws GraphReaderException {
        int to;
        int from;
        try (Scanner ssc = new Scanner(line);){
            ssc.useDelimiter("[\\s\\n,;]");
            from = ssc.nextInt();
            to = ssc.nextInt();
            if (!this.allVerticesPreAdded) {
                if (g.getGraph().get(from) == null) {
                    g.add(new Vertex(from));
                }
                if (g.getGraph().get(to) == null) {
                    g.add(new Vertex(to));
                }
            }
        }
        int vertexCount = g.getGraph().values().size();
        if (from >= vertexCount || to >= vertexCount) {
            throw new GraphReaderException("Invalid edge found between the following nodes: (" + from + ", " + to + ")");
        }
        Vertex fromGraph = g.getGraph().get(from);
        Vertex toGraph = g.getGraph().get(to);
        fromGraph.getOutAdjacents().add(toGraph);
        toGraph.getInAdjacents().add(fromGraph);
    }
}

