/*
 * Decompiled with CFR 0.152.
 */
package hu.unideb.inf.dina;

import hu.unideb.inf.dina.commons.exception.GraphReaderException;
import hu.unideb.inf.dina.commons.model.Graph;
import hu.unideb.inf.dina.commons.model.Vertex;
import hu.unideb.inf.dina.commons.reader.FileGraphReader;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;

public class GMLGraphReader
extends FileGraphReader {
    private Graph g;
    private int id = -1;
    private Map<String, Integer> idMapper = new HashMap<String, Integer>();
    private boolean stringId = false;
    private boolean intId = false;

    @Override
    public void readGraphFromInputStream(InputStream inputStream, Graph graph) throws GraphReaderException {
        graph.getGraph().clear();
        this.g = graph;
        try (Scanner sc = new Scanner(inputStream);){
            String rx = "[^\"\\s]+|\"(\\\\.|[^\\\\\"])*\"";
            block15: while (sc.hasNext()) {
                String nextWord = sc.findWithinHorizon(rx, 0);
                switch (nextWord.toLowerCase()) {
                    case "graph": {
                        if (!"[".equals(sc.findWithinHorizon(rx, 0))) {
                            throw new GraphReaderException("GML Syntax error at keyword \"graph\". \"[\" is missing.");
                        }
                        this.processGraphElement(sc, rx);
                        continue block15;
                    }
                    case "creator ": {
                        sc.findWithinHorizon(rx, 0);
                        continue block15;
                    }
                    case "version": {
                        sc.findWithinHorizon(rx, 0);
                        continue block15;
                    }
                }
                throw new GraphReaderException("Not supported GML keyword: " + nextWord);
            }
        }
    }

    private void processGraphElement(Scanner sc, String rx) throws GraphReaderException {
        block16: while (sc.hasNext()) {
            String nextWord = sc.findWithinHorizon(rx, 0);
            switch (nextWord.toLowerCase()) {
                case "node": {
                    if (!"[".equals(sc.findWithinHorizon(rx, 0))) {
                        throw new GraphReaderException("GML Syntax error at keyword \"node\". \"[\" is missing.");
                    }
                    this.procesNodeElement(sc, rx);
                    continue block16;
                }
                case "edge": {
                    if (!"[".equals(sc.findWithinHorizon(rx, 0))) {
                        throw new GraphReaderException("GML Syntax error at keyword \"edge\". \"[\" is missing.");
                    }
                    this.processEdgeElement(sc, rx);
                    continue block16;
                }
                case "comment": 
                case "directed": 
                case "id": 
                case "label": 
                case "hierarchic": {
                    sc.findWithinHorizon(rx, 0);
                    continue block16;
                }
                case "]": {
                    return;
                }
            }
            throw new GraphReaderException("Not supported GML keyword: " + nextWord);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void procesNodeElement(Scanner sc, String rx) throws GraphReaderException {
        newNode = null;
        label = "";
        block14: while (sc.hasNext()) {
            nextWord = sc.findWithinHorizon(rx, 0);
            var7_7 = nextWord.toLowerCase();
            var8_8 = -1;
            switch (var7_7.hashCode()) {
                case 3355: {
                    if (!var7_7.equals("id")) break;
                    var8_8 = 0;
                    break;
                }
                case 102727412: {
                    if (!var7_7.equals("label")) break;
                    var8_8 = 1;
                    break;
                }
                case 93: {
                    if (!var7_7.equals("]")) break;
                    var8_8 = 2;
                    break;
                }
                case -597057031: {
                    if (!var7_7.equals("thisisasampleattribute")) break;
                    var8_8 = 3;
                }
            }
            switch (var8_8) {
                case 0: {
                    gmlId = sc.findWithinHorizon(rx, 0);
                    try {
                        this.id = Integer.parseInt(gmlId);
                        this.intId = true;
                        if (this.stringId) {
                            throw new GraphReaderException("GML syntax error: All IDs have to be either String or Integer. Mixed types are not supported. Use \"1\", \"2\"... ");
                        }
                    }
                    catch (NumberFormatException ex) {
                        ++this.id;
                        this.stringId = true;
                        if (!this.intId) ** GOTO lbl37
                        throw new GraphReaderException("GML syntax error: All IDs have to be either String or Integer. Mixed types are not supported. Use \"1\", \"2\"... ");
                    }
lbl37:
                    // 2 sources

                    newNode = new Vertex(this.id);
                    newNode.getProperties().put("gml.id", gmlId);
                    this.idMapper.put((String)newNode.getProperties().get("gml.id"), this.id);
                    newNode.getProperties().put("gml.label", label);
                    this.g.add(newNode);
                    continue block14;
                }
                case 1: {
                    label = sc.findWithinHorizon(rx, 0);
                    if (newNode == null) continue block14;
                    newNode.getProperties().put("gml.label", label);
                    continue block14;
                }
                case 2: {
                    return;
                }
                case 3: {
                    sc.findWithinHorizon(rx, 0);
                    continue block14;
                }
            }
            throw new GraphReaderException("Not supported GML keyword: " + nextWord);
        }
    }

    private void processEdgeElement(Scanner sc, String rx) throws GraphReaderException {
        String source = null;
        String target = null;
        block14: while (sc.hasNext()) {
            String nextWord = sc.findWithinHorizon(rx, 0);
            switch (nextWord.toLowerCase()) {
                case "source": {
                    if (source != null) {
                        throw new GraphReaderException("GML syntax error when reading " + nextWord + " (duplicated source: " + source + ")");
                    }
                    source = sc.findWithinHorizon(rx, 0);
                    if (target == null) continue block14;
                    Vertex sourceVertex = this.g.getGraph().get(this.idMapper.get(source));
                    Vertex targetVertex = this.g.getGraph().get(this.idMapper.get(target));
                    sourceVertex.getOutAdjacents().add(targetVertex);
                    targetVertex.getInAdjacents().add(sourceVertex);
                    continue block14;
                }
                case "target": {
                    if (target != null) {
                        throw new GraphReaderException("GML syntax error when reading " + nextWord + " (duplicated source: " + source + ")");
                    }
                    target = sc.findWithinHorizon(rx, 0);
                    if (source == null) continue block14;
                    Vertex sourceVertex = this.g.getGraph().get(this.idMapper.get(source));
                    Vertex targetVertex = this.g.getGraph().get(this.idMapper.get(target));
                    sourceVertex.getOutAdjacents().add(targetVertex);
                    targetVertex.getInAdjacents().add(sourceVertex);
                    continue block14;
                }
                case "label": {
                    sc.findWithinHorizon(rx, 0);
                    continue block14;
                }
                case "thisisasampleattribute": {
                    sc.findWithinHorizon(rx, 0);
                    continue block14;
                }
                case "]": {
                    return;
                }
            }
            throw new GraphReaderException("Not supported GML keyword: " + nextWord);
        }
    }
}

