/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package domtest;

import java.io.File;
import java.io.IOException;
import java.util.Scanner;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/**
 *
 * @author admin
 */
public class DOMTest {

    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {
        try {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            Document doc;
            try {
                doc = docBuilder.parse("student.xml"); //try to open file
            } catch (SAXException | IOException ex) {
                doc = docBuilder.newDocument(); //if the file does not exist, open a new one
            }
            
            

        } catch (ParserConfigurationException ex) {
            Logger.getLogger(DOMTest.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static void printAllStudents(Document doc) {
        Node root = doc.getDocumentElement();
        if (root == null) {
            return;
        }
        NodeList nList = root.getChildNodes();
        for (int i = 0; i < nList.getLength(); i++) {
            Node nNode = nList.item(i);
            if (nNode.getNodeType() == Node.ELEMENT_NODE) {
                Element eElement = (Element) nNode;
                System.out.println("Student id : " + eElement.getAttribute("id"));
                System.out.println("First Name : " + eElement.getElementsByTagName("firstname").item(0).getTextContent());
                System.out.println("Last Name : " + eElement.getElementsByTagName("lastname").item(0).getTextContent());
                System.out.println("Credits : " + eElement.getElementsByTagName("credits").item(0).getTextContent());
            }
        }
    }

    public static void searchStudent(Document doc) {
        //TODO in Ex. 6
    }

    public static void addStudent(Document doc) { //Modify this in Ex. 5
        Element newStudent = doc.createElement("student");
        Element fName = doc.createElement("firstname");
        Element lName = doc.createElement("lastname");
        Element credits = doc.createElement("credits");

        Scanner sc = new Scanner(System.in);
        System.out.print("Student id: ");
        newStudent.setAttribute("id", sc.nextLine());

        Node root = doc.getDocumentElement();
        if (root == null) {
            root=doc.createElement("group");
            doc.appendChild(root);
        }
        root.appendChild(newStudent);
        saveFile(doc);
    }

    public static void deleteStudent(Document doc) {
        //TODO in Ex. 7
    }

    private static void saveFile(Document doc) {
        try {        // write the content into xml file
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer;
            transformer = transformerFactory.newTransformer();
            DOMSource source = new DOMSource(doc);
            StreamResult result = new StreamResult(new File("student.xml"));
            transformer.transform(source, result);
        } catch (TransformerConfigurationException ex) {
            Logger.getLogger(DOMTest.class.getName()).log(Level.SEVERE, null, ex);
        } catch (TransformerException ex) {
            Logger.getLogger(DOMTest.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

}
