import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Sample1 {

	public static void main(String[] args) {

		Stream.of("a1", "a2", "a3", "a4", "a5")
    		.map(s -> s.substring(1))
    		.mapToInt(Integer::parseInt)
    		.max()
    		.ifPresent(System.out::println);
				
		Cat morris = new Cat("Morris", 4, 8);
		Cat zoli = new Cat("Zoltán", 4, 8);
		Cat garfield = new Cat("Garfield", 45, 23);
		Cat grumpycat = new Cat("Grumpycat", 3, 4);

		List<Cat> cats = new ArrayList<Cat>();

		cats.add(garfield);
		cats.add(grumpycat);
		cats.add(morris);
		cats.add(zoli);

		Stream.of("a1", "a2", "a3", "a4", "a5")
	    	.map(s -> s.substring(1))
	    	.mapToInt(Integer::parseInt)
	    	.max()
	    	.ifPresent(System.out::println);
		
		// 5 évnél öregebb macskák névszerint rendezve...
		cats.stream().filter(c -> c.getAge() > 5)
				.sorted((c1, c2) -> c1.getName().compareTo(c2.getName()))
				.forEach(System.out::println);

		// G betűs macsekok
		cats.stream().filter(c -> c.getName().startsWith("G"))
				.forEach(System.out::println);

		// Dagi macsekok
		List<Cat> dagimacskak = cats.stream().filter(c -> c.getAge() > 5)
				.sorted((c1, c2) -> c1.getName().compareTo(c2.getName()))
				.collect(Collectors.toList());

		dagimacskak.stream().forEach(System.out::println);

		// macsekok kor szerint
		Map<Integer, List<Cat>> macskakKorSzerint = cats.stream().collect(
				Collectors.groupingBy(Cat::getAge));

		// kiírjuk
		for (Integer age : macskakKorSzerint.keySet()) {
			System.out.println(age);
			for (Cat cat : macskakKorSzerint.get(age)) {
				System.out.println(cat);
			}
		}

		// perverz kiírás
		macskakKorSzerint
				.keySet()
				.stream()
				.forEach(
						i -> macskakKorSzerint.get(i).stream()
								.forEach(System.out::println));

		// legkövérebb macska súlya
		cats.stream().mapToInt(Cat::getWeight).max()
				.ifPresent(System.out::println);

		cats.stream().max((c1, c2) -> c1.getWeight() - c2.getWeight())
				.ifPresent(System.out::println);

		cats.stream().max((c1, c2) -> c1.getWeight() - c2.getWeight())
				.ifPresent(c -> {
					System.out.println(c.getWeight());
				});

		System.out.println(cats.stream()
				.max((c1, c2) -> c1.getWeight() - c2.getWeight()).get()
				.getWeight());

		cats.stream()
				.reduce((c1, c2) -> c1.getWeight() > c2.getWeight() ? c1 : c2)
				.ifPresent(System.out::println);

	}
}
