package keresofa;

import java.util.LinkedList;
import java.util.List;

import visszalepeses.Korfigyeles;
import korsok.Allapot;
import korsok.Operator;
import korsok.Problema;

public class Szelessegi {
	
	public List<Operator> megoldas(Csucs terminalis) {
		LinkedList<Operator> megoldas = new LinkedList<Operator>();
		for (Csucs cs=terminalis; cs.szulo != null; cs=cs.szulo)
			megoldas.addFirst(cs.eloallito);
		return megoldas;
	}
	
	static class Csucs {
		Allapot allapot;
		Csucs szulo;
		Operator eloallito;
		//int melyseg;
		
		public Csucs(Allapot allapot, Csucs szulo, Operator eloallito) {
			this.allapot = allapot;
			this.szulo = szulo;
			this.eloallito = eloallito;
			//this.melyseg = szulo == null ? 0 : szulo.melyseg + 1;
		}
	}
	
	public List<Operator> keres(Problema p) {
		LinkedList<Csucs> nyiltak = new LinkedList<Szelessegi.Csucs>();
		LinkedList<Csucs> zartak  = new LinkedList<Szelessegi.Csucs>();
		// 1.
		nyiltak.add( new Csucs(p.kezdo(), null, null));
		
		while (true) {
			// 2.
			if ( nyiltak.isEmpty() ) {
				return null;
			}
			// Kivlaszt
			Csucs kivalasztott = nyiltak.removeFirst();
			// 3.
			if ( kivalasztott.allapot.cel() ) {
				return megoldas(kivalasztott);
			}
			// Kiterjeszts
			zartak.add(kivalasztott);
			for (Operator o: p.operatorok()) 
				if ( o.alkalmazhato(kivalasztott.allapot)) {
					Allapot uj = o.alkalmaz(kivalasztott.allapot);
					
					boolean voltMar = false;
					for (Csucs cs: nyiltak)
						if (cs.allapot.equals(uj)) {
							voltMar = true;
							break;
						}
					for (Csucs cs: zartak)
						if (cs.allapot.equals(uj)) {
							voltMar = true;
							break;
						}
					
					if ( ! voltMar ) {
						nyiltak.addLast( new Csucs(uj, kivalasztott, o));
					}
				}
		}
	}
	
	public static void main(String[] args) {
		Problema p = new Problema();
		List<Operator> m = new Szelessegi().keres(p);
		if ( m!= null ) {
			Allapot a = p.kezdo();
			for (Operator o:m) {
				System.out.println(a);
				System.out.println(o);
				a = o.alkalmaz(a);
			}
			System.out.println(a);
		}
	}
	

}
