package keresofa;

import java.util.LinkedList;
import java.util.List;

import visszalepeses.Korfigyeles;
import korsok.Allapot;
import korsok.Operator;
import korsok.Problema;

public class Optimalis {
	
	public List<Operator> megoldas(Csucs terminalis) {
		LinkedList<Operator> megoldas = new LinkedList<Operator>();
		for (Csucs cs=terminalis; cs.szulo != null; cs=cs.szulo)
			megoldas.addFirst(cs.eloallito);
		return megoldas;
	}
	
	static class Csucs {
		Allapot allapot;
		Csucs szulo;
		Operator eloallito;
		double utkoltseg;
		
		public Csucs(Allapot allapot, Csucs szulo, Operator eloallito, Koltseg k) {
			this.allapot = allapot;
			this.szulo = szulo;
			this.eloallito = eloallito;
			this.utkoltseg = szulo == null ? 0 : 
				szulo.utkoltseg + k.elkoltseg(szulo.allapot, eloallito);
		}
	}
	
	public interface Koltseg {
		double elkoltseg(Allapot a, Operator o);
	}
	
	public List<Operator> keres(Problema p, Koltseg k) {
		LinkedList<Csucs> nyiltak = new LinkedList<Optimalis.Csucs>();
		LinkedList<Csucs> zartak  = new LinkedList<Optimalis.Csucs>();
		// 1.
		nyiltak.add( new Csucs(p.kezdo(), null, null, k));
		
		while (true) {
			// 2.
			if ( nyiltak.isEmpty() ) {
				return null;
			}
			// Kivlaszt
			Csucs kivalasztott = nyiltak.removeFirst();
			// 3.
			if ( kivalasztott.allapot.cel() ) {
				return megoldas(kivalasztott);
			}
			// Kiterjeszts
			zartak.add(kivalasztott);
			for (Operator o: p.operatorok()) 
				if ( o.alkalmazhato(kivalasztott.allapot)) {
					Allapot uj = o.alkalmaz(kivalasztott.allapot);
					
					Csucs korabbi = null;
					for (Csucs cs: nyiltak)
						if (cs.allapot.equals(uj)) {
							korabbi = cs;
							break;
						}
					
					if ( korabbi != null ) {
						
						double ujkoltseg = kivalasztott.utkoltseg + k.elkoltseg(kivalasztott.allapot, o);
						if ( korabbi.utkoltseg > ujkoltseg ) {
							korabbi.eloallito = o;
							korabbi.szulo = kivalasztott;
							korabbi.utkoltseg = ujkoltseg;
						}
						
					} else {
					
						for (Csucs cs: zartak)
							if (cs.allapot.equals(uj)) {
								korabbi = cs;
								break;
							}
						
						if ( korabbi == null ) {
							nyiltak.addLast( new Csucs(uj, kivalasztott, o, k));
						}
						
					}
					
				}
		}
	}
	
	public static void main(String[] args) {
		Problema p = new Problema();
		List<Operator> m = new Optimalis().keres(p,
					(a,o)-> {
						return Math.min(a.a[o.i], Operator.max[o.j]-a.a[o.j]);
					}
				);
		if ( m!= null ) {
			Allapot a = p.kezdo();
			for (Operator o:m) {
				System.out.println(a);
				System.out.println(o);
				a = o.alkalmaz(a);
			}
			System.out.println(a);
		}
	}
	

}
