package keresofa;

import java.util.LinkedList;
import java.util.List;

import korsok.Allapot;
import korsok.Heurisztika;
import korsok.Operator;
import korsok.Problema;

public class BestFirst {
	
	static class Csucs {
		Allapot allapot;
		Operator eloallito;
		Csucs szulo;
		double heurisztika;
		
		public Csucs(Allapot allapot, Operator eloallito, Csucs szulo, Heurisztika h) {
			this.allapot = allapot;
			this.eloallito = eloallito;
			this.szulo = szulo;
			this.heurisztika = h.heur(allapot);
		}
	}

	public List<Operator> keres(Problema p, Heurisztika h) {
		LinkedList<Csucs> nyiltak = new LinkedList<BestFirst.Csucs>();
		LinkedList<Csucs> zartak  = new LinkedList<BestFirst.Csucs>();
		// 1.
		nyiltak.add( new Csucs(p.kezdo(), null, null, h));
		
		while (true) {
			// 2.
			if ( nyiltak.isEmpty() ) {
				return null;
			}
			// kivlaszt
			Csucs kivalasztott = null;
			for (Csucs c: nyiltak) {
				if ( kivalasztott == null || kivalasztott.heurisztika > c.heurisztika )
					kivalasztott = c;
			}
			// 3.
			if ( kivalasztott.allapot.cel() ) {
				LinkedList<Operator> megoldas = new LinkedList<Operator>();
				for ( Csucs c=kivalasztott; c.szulo!=null; c=c.szulo ) {
					megoldas.addFirst(c.eloallito);
				}
				return megoldas;
			}
			// kiterjeszt
			nyiltak.remove(kivalasztott);
			zartak.add(kivalasztott);
			
			for ( Operator o: p.operatorok() ) {
				if (o.alkalmazhato(kivalasztott.allapot)) {
					Allapot uj = o.alkalmaz(kivalasztott.allapot);
					
					boolean voltMar = false;
					for (Csucs c: nyiltak) {
						if (c.allapot.equals(uj)) {
							voltMar = true;
							break;
						}
					}
					if ( !voltMar ) for (Csucs c: zartak) {
						if (c.allapot.equals(uj)) {
							voltMar = true;
							break;
						}
					}
					
					if ( !voltMar ) {
						nyiltak.add( new Csucs(uj, o, kivalasztott, h));
					}
					
				}
			}
		}
	}
	
	
	public static void main(String[] arg) {
		Problema p = new Problema();
		List<Operator> megoldas = new BestFirst().keres(p, 
					(a) -> {
						return a.hashCode();
					}
				);
		System.out.println(megoldas);
	}
	
}
