package keresofa;

import java.util.LinkedList;
import java.util.List;

import korsok.Allapot;
import korsok.Heurisztika;
import korsok.Koltseg;
import korsok.Operator;
import korsok.Problema;

public class A {
	
	static class Csucs {
		Allapot allapot;
		Operator eloallito;
		Csucs szulo;
		double osszkoltseg;
		
		public Csucs(Allapot allapot, Operator eloallito, Csucs szulo, Heurisztika h, Koltseg k) {
			this.allapot = allapot;
			this.eloallito = eloallito;
			this.szulo = szulo;
			this.osszkoltseg = szulo == null ? h.heur(allapot) :
					+ szulo.osszkoltseg
					- h.heur(szulo.allapot)
					+ k.elkoltseg(szulo.allapot, eloallito)
					+ h.heur(allapot);
		}
	}

	public List<Operator> keres(Problema p, Heurisztika h, Koltseg k) {
		LinkedList<Csucs> nyiltak = new LinkedList<A.Csucs>();
		LinkedList<Csucs> zartak  = new LinkedList<A.Csucs>();
		// 1.
		nyiltak.add( new Csucs(p.kezdo(), null, null, h, k));
		
		while (true) {
			// 2.
			if ( nyiltak.isEmpty() ) {
				return null;
			}
			// kivlaszt
			Csucs kivalasztott = null;
			for (Csucs c: nyiltak) {
				if ( kivalasztott == null || kivalasztott.osszkoltseg > c.osszkoltseg )
					kivalasztott = c;
			}
			// 3.
			if ( kivalasztott.allapot.cel() ) {
				LinkedList<Operator> megoldas = new LinkedList<Operator>();
				for ( Csucs c=kivalasztott; c.szulo!=null; c=c.szulo ) {
					megoldas.addFirst(c.eloallito);
				}
				return megoldas;
			}
			// kiterjeszt
			nyiltak.remove(kivalasztott);
			zartak.add(kivalasztott);
			
			for ( Operator o: p.operatorok() ) {
				if (o.alkalmazhato(kivalasztott.allapot)) {
					Allapot uj = o.alkalmaz(kivalasztott.allapot);
					
					Csucs regi = null;
					for (Csucs c: nyiltak) {
						if ( c.allapot.equals(uj) ) {
							regi = c;
							break;
						}
					}
					
					double ujosszkoltseg = 
							+ kivalasztott.osszkoltseg
							- h.heur(kivalasztott.allapot)
							+ k.elkoltseg(kivalasztott.allapot, o)
							+ h.heur(uj);
					if ( regi != null ) {
						if ( ujosszkoltseg < regi.osszkoltseg ) {
							// Nylt cscs frissts
							regi.szulo = kivalasztott;
							regi.eloallito = o;
							regi.osszkoltseg = ujosszkoltseg;
						}
					} else {
						for (Csucs c: zartak) {
							if ( c.allapot.equals(uj)) {
								regi = c;
								break;
							}
						}
						if ( regi != null) {
							if ( ujosszkoltseg < regi.osszkoltseg ) {
								// Zrt cscs frissts
								regi.szulo = kivalasztott;
								regi.eloallito = o;
								regi.osszkoltseg = ujosszkoltseg;
								zartak.remove(regi);
								nyiltak.add(regi);
							}
						} else {
							nyiltak.add( new Csucs(uj, o, kivalasztott, h, k));
						}
					}
					
				}
			}
		}
	}
	
	
	public static void main(String[] arg) {
		Problema p = new Problema();
		List<Operator> megoldas = new A().keres(p, 
					(a) -> {
						return 0;
					},
					(a,o) -> {
						return 1;
					}
				);
		System.out.println(megoldas);
	}
	
}
// 