package playstate;

public class MinMax {

	static public PlayStep offer( PlayState state, PlaySpace ps, MinMaxHeur heur ) {
		int max = Integer.MIN_VALUE;
		PlayStep bestStep = null;
		for ( PlayStep step : ps.steps() ) 
			if ( step.applicable(state) ) {
				int val = eval( step.apply(state), state.player, ps, heur, 3 );
				if ( max < val ) {
					max = val;
					bestStep = step;
				}
			}
		System.out.println(max);
		return bestStep;
	}
	
	static private int eval( PlayState state, int supportedPlayer, PlaySpace ps, MinMaxHeur heur, int limit ) {
		if ( state.isEnd() || limit == 0 )
			return heur.heuristic(state.state, supportedPlayer);
		
		if ( state.player == supportedPlayer ) {
			int max = Integer.MIN_VALUE;
			for ( PlayStep step : ps.steps() ) 
				if ( step.applicable(state) ) {
					int val = eval( step.apply(state), supportedPlayer, ps, heur, limit-1 );
					if ( max < val ) {
						max = val;
					}
				}
			return max;
		} else {
			int min = Integer.MAX_VALUE;
			for ( PlayStep step : ps.steps() ) 
				if ( step.applicable(state) ) {
					int val = eval( step.apply(state), supportedPlayer, ps, heur, limit-1 );
					if ( min > val ) {
						min = val;
					}
				}
			return min;
		}
	}
	
	
}
