package gamestate;

public class GameStep {

	final int i,j,k;
	
	public GameStep(int i, int j, int k) {
		this.i = i;
		this.j = j;
		this.k = k;
	}
	
	public boolean applicable(GameState gs) {
		return (k != 1 || gs.g1() == gs.g2()) && (k != 2 || gs.g1() > gs.g2()) && gs.a[i][j] == 0;
	}
	
	public GameState apply(GameState gs) {
		GameState newState = new GameState();
		for (int i=1; i<=3; i++)
			for (int j=1; j<=3; j++)
				newState.a[i][j] = (i==this.i && j==this.j) ? k : gs.a[i][j];
		return newState;
	}
	
	@Override
	public String toString() {
		return new StringBuffer().append(i).append(',').append(j).append(" ").toString();
	}
	
	
}
