package playstate;

import gamestate.GameStep;

public class PlayStep {

	GameStep l1, l2;
	
	public PlayStep(int i, int j) {
		l1 = new GameStep(i, j, 1);
		l2 = new GameStep(i, j, 2);
	}
	
	public boolean applicable( PlayState ps ) {
		return ps.player == 1 ? l1.applicable(ps.state) : l2.applicable(ps.state);
	}
	
	public PlayState apply( PlayState ps ) {
		PlayState newState = new PlayState(
				ps.player == 1 ? l1.apply(ps.state) : l2.apply(ps.state), 
				3 - ps.player);
		return newState;
	}
	
	public String toString() {
		return l1.toString();
	}
	
}
