package kennedy;

public class State {
	
	Object[][] a = new Object[6][6];
	
	public State() {
		// START STATE
		for (int i = 1; i <= 5; i++)
			for (int j = 1; j <= 5; j++)
				a[i][j] = null;
	}
	
	public boolean isGoal() {
		// GOAL CONDITION
		return a[5][5] != null;
	}
	
	@Override
	public String toString() {
		StringBuffer sb = new StringBuffer();
		for (int i = 1; i <= 5; i++) {
			for (int j = 1; j <= 5; j++) {
				sb.append( cell(a[i][j]) ).append(" ");
			}
			sb.append("\n");
		}
		return sb.toString();
	}
	
	private static String cell(Object s) {
		StringBuffer sb = new StringBuffer(s==null?"-":s.toString());
		while (sb.length() < 15 )
			sb.append(" ");
		return sb.toString();
	}
	
	
	@Override
	public boolean equals(Object obj) {
		if ( obj == null || !(obj instanceof State) )
			return false;
		
		Object b[][] = ((State)obj).a;
		for (int i = 1; i <= 5; i++)
			for (int j = 1; j <= 5; j++)
				if ( a[i][j] != b[i][j])
					return false;

		return true;
	}
	
	
	

}
