package kennedy;

public class NationOperator implements Operator {

	int k;
	
	Nation v;
	
	public NationOperator(int k, Nation v) {
		super();
		this.k = k;
		this.v = v;
	}

	@Override
	public boolean isApplicabe(State state) {
		Object[][] a = state.a;
		
		if ( ! (a[2][k] == null) )
			return false;
		
		if ( ! (a[1][5] != null) )
			return false;
		
		boolean cond = true;
		for (int i = 1; i <= 5; i++)
			cond = cond && ( i >= k || a[2][i] != null );
		if ( !cond )
			return false;
		
		cond = true;
		for (int i = 1; i <= 5; i++)
			cond = cond && ( i >= k || a[2][i] != v );
		if ( !cond )
			return false;
		
//		1. The Englishman lives in the red house.
		if ( (v == Nation.ENGLISHMAN) != (a[1][k] == Color.RED) )
			return false;
		
//		9. The Norwegian lives in the first house on the left.
		if ( (v==Nation.NORWEGIAN) != (k==1) )
			return false;

//		14. The Norwegian lives next to the blue house.
		int blue = -1;
		for ( int i = 1; i <= 5; i++ )
			if ( a[1][i] == Color.BLUE )
				blue = i;
		if (!( !(v==Nation.NORWEGIAN) || (Math.abs(k-blue)==1) ))
			return false;
		
		return true;
	}

	@Override
	public State apply(State state) {
		State newState = new State();
		Object[][] a = state.a;
		Object[][] b = newState.a;
		
		for (int i = 1; i <= 5; i ++)
			for (int j = 1; j <= 5; j ++)
				b[i][j] = ( i == 2 && j == k ) ? v : a[i][j];

		return newState;
	}

}
