package kennedy;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class Main {

	/**
	 * @param args
	 */
	public static void main(String[] args) {

		List<Operator> operators = new ArrayList<>();
		for (int k = 1; k <= 5; k++) {
			for (Color v : Color.values())
				operators.add(new ColorOperator(k, v));
			for (Nation v : Nation.values())
				operators.add(new NationOperator(k, v));
			for (Cigarette v : Cigarette.values())
				operators.add(new CigaretteOperator(k, v));
			for (Drink v : Drink.values())
				operators.add(new DrinksOperator(k, v));
			for (Pet v : Pet.values())
				operators.add(new PetOperator(k, v));
		}

		Random random = new Random();
		for (int i = 0; true; i++) {

			// Trial-and-error algorithm
			State actualState = new State();

			while (true) {

				if (actualState.isGoal()) {
					System.out.print("number of trials: "+ i);
					System.out.print("\n\n");
					System.out.print(actualState);
					return;
				}

				List<Operator> applicable = new ArrayList<>();
				for (Operator o : operators)
					if (o.isApplicabe(actualState))
						applicable.add(o);

				if (applicable.isEmpty()) {
					break;
				}

				Operator o = applicable.get(random.nextInt(applicable.size()));
				actualState = o.apply(actualState);
			}
		}

	}

}
