package kennedy;

public class DrinksOperator implements Operator {

	int k;
	
	Drink v;
	
	public DrinksOperator(int k, Drink v) {
		super();
		this.k = k;
		this.v = v;
	}

	@Override
	public boolean isApplicabe(State state) {
		Object[][] a = state.a;
		
		if ( ! (a[4][k] == null) )
			return false;
		
		if ( ! (a[3][5] != null) )
			return false;
		
		boolean cond = true;
		for (int i = 1; i <= 5; i++)
			cond = cond && ( i >= k || a[4][i] != null );
		if ( !cond )
			return false;
		
		cond = true;
		for (int i = 1; i <= 5; i++)
			cond = cond && ( i >= k || a[4][i] != v );
		if ( !cond )
			return false;

//		3. Coffee is drunk in the green house.
		if ( (a[1][k] == Color.GREEN) != (v == Drink.COFFEE) )
			return false;
		
//		4. The Ukrainian drinks tea.
		if ( (a[2][k] == Nation.UKRAINIAN) != (Drink.TEA == v))
			return false;

//		8. Milk is drunk in the middle house.
		if ( ( k == 3 ) != ( v == Drink.MILK ) )
			return false;

//		12. The Lucky-Strike smoker drinks orange juice.
		if ( (a[3][k] == Cigarette.LUCKY_STRIKE) != ( Drink.ORANGE_JUICE == v) )
			return false;
		
//		2. The Spaniard owns a dog.
//		6. The Old-Gold smoker owns snails.
//		10. The Chesterfield smoker lives next to the fox owner.
//		11. Kools are smoked in the house next to the house where the horse is kept.
		
		return true;
	}

	@Override
	public State apply(State state) {
		State newState = new State();
		Object[][] a = state.a;
		Object[][] b = newState.a;
		
		for (int i = 1; i <= 5; i ++)
			for (int j = 1; j <= 5; j ++)
				b[i][j] = ( i == 4 && j == k ) ? v : a[i][j];

		return newState;
	}

}
