package kennedy;

public class CigaretteOperator implements Operator {

	int k;
	
	Cigarette v;
	
	public CigaretteOperator(int k, Cigarette v) {
		super();
		this.k = k;
		this.v = v;
	}

	@Override
	public boolean isApplicabe(State state) {
		Object[][] a = state.a;
		
		if ( ! (a[3][k] == null) )
			return false;
		
		if ( ! (a[2][5] != null) )
			return false;
		
		boolean cond = true;
		for (int i = 1; i <= 5; i++)
			cond = cond && ( i >= k || a[3][i] != null );
		if ( !cond )
			return false;
		
		cond = true;
		for (int i = 1; i <= 5; i++)
			cond = cond && ( i >= k || a[3][i] != v );
		if ( !cond )
			return false;

//		7. Kools are being smoked in the yellow house.
		if ( (v == Cigarette.KOOLS) != (a[1][k] == Color.YELLOW) )
			return false;

//		13. The Japanese smokes Parliament.
		if ( (v == Cigarette.PARLIAMENT) != (a[2][k] == Nation.JAPANESE) )
			return false;
			
//		2. The Spaniard owns a dog.
//		3. Coffee is drunk in the green house.
//		4. The Ukrainian drinks tea.
//		6. The Old-Gold smoker owns snails.
//		8. Milk is drunk in the middle house.
//		10. The Chesterfield smoker lives next to the fox owner.
//		11. Kools are smoked in the house next to the house where the horse is kept.
//		12. The Lucky-Strike smoker drinks orange juice.
		
		return true;
	}

	@Override
	public State apply(State state) {
		State newState = new State();
		Object[][] a = state.a;
		Object[][] b = newState.a;
		
		for (int i = 1; i <= 5; i ++)
			for (int j = 1; j <= 5; j ++)
				b[i][j] = ( i == 3 && j == k ) ? v : a[i][j];

		return newState;
	}

}
