package kennedy;

public class PetOperator implements Operator {

	int k;
	
	Pet v;
	
	public PetOperator(int k, Pet v) {
		super();
		this.k = k;
		this.v = v;
	}

	@Override
	public boolean isApplicabe(State state) {
		Object[][] a = state.a;
		
		if ( ! (a[5][k] == null) )
			return false;
		
		if ( ! (a[4][5] != null) )
			return false;
		
		boolean cond = true;
		for (int i = 1; i <= 5; i++)
			cond = cond && ( i >= k || a[5][i] != null );
		if ( !cond )
			return false;
		
		cond = true;
		for (int i = 1; i <= 5; i++)
			cond = cond && ( i >= k || a[5][i] != v );
		if ( !cond )
			return false;
		
//		2. The Spaniard owns a dog.
		if ( (a[2][k]==Nation.SPANIARD) != (v==Pet.DOG) )
			return false;
		
//		6. The Old-Gold smoker owns snails.
		if ( (a[3][k] == Cigarette.OLD_GOLD) != (v == Pet.SNAILS) )
			return false;
		
//		10. The Chesterfield smoker lives next to the fox owner.
		int chesterfiled = -1;
		for ( int i = 1; i <= 5; i++ )
			if ( a[3][i] == Cigarette.CHESTERFIELD )
				chesterfiled = i;
		if ( !( !(v == Pet.FOX) || (Math.abs(k-chesterfiled) == 1)) )
			return false;
		
//		11. Kools are smoked in the house next to the house where the horse is kept.
		int kools = -1;
		for ( int i = 1; i <= 5; i++ )
			if ( a[3][i] == Cigarette.KOOLS )
				kools = i;
		if ( !( !(v == Pet.HORSE) || ( Math.abs(k-kools) ==1 )) )
			return false;
		
		return true;
	}

	@Override
	public State apply(State state) {
		State newState = new State();
		Object[][] a = state.a;
		Object[][] b = newState.a;
		
		for (int i = 1; i <= 5; i ++)
			for (int j = 1; j <= 5; j ++)
				b[i][j] = ( i == 5 && j == k ) ? v : a[i][j];

		return newState;
	}

}
