package hu.unideb.inf.ai.jars;

import java.util.ArrayList;
import java.util.List;

import javax.swing.plaf.SliderUI;

public class OptimalSearch {

	public static void main(String[] args) {
		search();
	}
	
	public static void search() {
		// DATABASE
		
		class Node {
			State state;
			Node parent;
			Operator creator;
			boolean open;
			double pathCost;
			
			public Node(State state, Node parent, Operator creator) {
				this.state = state;
				this.parent = parent;
				this.creator = creator;
				this.open = true;
				this.pathCost = parent == null ? 0 : parent.pathCost + creator.cost(parent.state);
			}
			
		}
		
		List<Node> nodes = new ArrayList<>();
		
		// CONTROLLER 
		nodes.add( new Node(State.start(), null, null));
		
		while (true) {
			
			Node select = null;
			for( Node node: nodes )
				if ( node.open && ( select == null || select.pathCost > node.pathCost ) )
					select = node;
			
			if ( select == null ) {
				System.out.println("The problem is not solvable!");
				break;
			}
			
			if ( select.state.isGoal() ) {
				System.out.println("Solution found! Goal: "+ select.state);
				
				List<Operator> solution = new ArrayList<>();
				for (Node node = select; node.parent != null; node = node.parent )
					solution.add(0, node.creator);
				
				State s = State.start();
				double cost = 0;
				for (Operator op: solution) {
					System.out.print(s);
					System.out.print(" ");
					System.out.print(op);
					cost += op.cost(s);
					s = op.apply(s);
					System.out.print(" ");
					System.out.print(s);
					System.out.print(" ");
					System.out.print(cost);
					System.out.println();
				}
				
				break;
			}
			
			// EXPAND:
			for ( Operator op: Operator.OPERATORS ) 
				if ( op.isApplicable(select.state)) {
					State newState = op.apply(select.state);
					
					Node similar = null;
					for (Node node : nodes)
						if ( node.state.equals(newState) ) {
							similar = node;
							break;
						}
					
					if ( similar == null ) {
						nodes.add( new Node(newState, select, op));
					} else {
						if ( similar.pathCost > select.pathCost+op.cost(select.state) ) {
							// Open node problem
							similar.pathCost = select.pathCost+op.cost(select.state);
							similar.parent = select;
							similar.creator = op;
						}
					}
							
				}
			select.open = false;
		}
		
		
	}
	
}
