package hu.unideb.inf.ai.jars;

import java.util.ArrayList;
import java.util.List;

public class Backtrack {
	
	public static void main(String args[]) {
			search();
	} 


	public static void search() {
		// DATABASE
		class Node {
			State state;
			Node parent;
			Operator creator;
			List<Operator> untried;
			
			public Node(State state, Node parent, Operator creator) {
				this.state = state;
				this.parent = parent;
				this.creator = creator;
				untried = new ArrayList<>();
				for (Operator o : Operator.OPERATORS)
					if (o.isApplicable(state))
						untried.add(o);
			}
		}
		Node current;
		
		// CONTROLLER
		current = new Node(State.start(), null, null);
		final int limit = 4;
		int length = 1;
		
		while (true) {
			
			if ( ! current.untried.isEmpty() /* && length < limit */ ) {
				Operator o = current.untried.remove(0);
				State newState = o.apply(current.state);
				
				boolean found = false;
				for (Node n = current; n != null; n=n.parent)
					if ( n.state.equals(newState))
						found = true;
				
				if ( ! found ) {
					current = new Node(newState, current, o);
					length++;
					if (current.state.isGoal()) {
						System.out.println(current.state);
						break;
					}
				}
				
			} else {
				
				if ( current.parent != null ) {
					current = current.parent;
					length--;
				} else {
					System.out.println("Not solvable.");
					break;
				}
			}
			
		}
		
		if (current.state.isGoal()) {
			ArrayList<Operator> solution = new ArrayList<>();
			for ( ; current.parent != null; current = current.parent  )
				solution.add(0,current.creator);
			for ( Operator o : solution )
				System.out.println(o);
		}
	}
	
	
}
