package hu.unideb.inf.ai.jars;

import java.util.ArrayList;
import java.util.Random;

public class TrialAndError {
	
	public static void main(String args[]) {
		for (int i=1; i<=100; i++)
			search();
	} 
	
	public static void search() {
		// DATABASE
		State current;
		
		// CONTROLLER
		current = State.start();
		int counter = 0;
		while (true) {
			
			if ( current.isGoal() ) {
				System.out.println(current);
				break;
			}
			
			ArrayList<Operator> applicables = new ArrayList<>();
			for (Operator o: Operator.OPERATORS) {
				applicables.add(o);
			}
			
			if ( applicables.isEmpty() ) {
				System.out.println(":-(");
				break;
			}
			
			Operator o = applicables.get(new Random().nextInt(applicables.size()));
			current = o.apply(current);
			counter++;
		}
		System.out.println(counter);
	}

}
