package hu.unideb.inf.ai.jars;

import java.util.ArrayList;
import java.util.List;

import javax.swing.plaf.SliderUI;

public class DepthFirst {

	public static void main(String[] args) {
		search();
	}
	
	public static void search() {
		// DATABASE
		
		class Node {
			State state;
			Node parent;
			Operator creator;
			boolean open;
			int level;
			
			public Node(State state, Node parent, Operator creator) {
				this.state = state;
				this.parent = parent;
				this.creator = creator;
				this.open = true;
				this.level = parent == null ? 0 : parent.level+1;
			}
			
		}
		
		List<Node> nodes = new ArrayList<>();
		
		// CONTROLLER 
		nodes.add( new Node(State.start(), null, null));
		
		while (true) {
			// SELECTION
			Node select = null;
			for( Node node: nodes )
				if ( node.open && ( select == null || select.level < node.level ) )
					select = node;
			
			if ( select == null ) {
				System.out.println("The problem is not solvable!");
				break;
			}
			
			if ( select.state.isGoal() ) {
				System.out.println("Solution found! Goal: "+ select.state);
				
				List<Operator> solution = new ArrayList<>();
				for (Node node = select; node.parent != null; node = node.parent )
					solution.add(0, node.creator);
				
				State s = State.start();
				double cost = 0;
				for (Operator op: solution) {
					System.out.print(s);
					System.out.print(" ");
					System.out.print(op);
					cost += op.cost(s);
					s = op.apply(s);
					System.out.print(" ");
					System.out.print(s);
					System.out.print(" ");
					System.out.print(cost);
					System.out.println();
				}
				
				break;
			}
			
			// EXPAND:
			for ( Operator op: Operator.OPERATORS ) 
				if ( op.isApplicable(select.state)) {
					State newState = op.apply(select.state);
					
					Node similar = null;
					for (Node node : nodes)
						if ( node.state.equals(newState) ) {
							similar = node;
							break;
						}
					
					if ( similar == null ) {
						nodes.add( new Node(newState, select, op));
					} else {
					}
				}
			select.open = false;
		}
		
		
	}
	
}
