package playstate;

import gamestate.GameState;

public class PlayState {
	
	final GameState state;
	
	final int player;
	
	public PlayState(GameState state, int player) {
		this.state = state;
		this.player = player;
	}
	
	public PlayState() {
		this.state = new GameState();
		this.player = 1;
	}
	
	public boolean isEnd() {
		return state.isEnd();
	}

	@Override
	public String toString() {
		if ( isEnd() ) {
			StringBuffer result = new StringBuffer(state.toString()).append("\n End ");
			if ( state.isNotDeal() )
				result.append( player == 2 ? "A":"B").append(" win.");
			else
				result.append("DEAL");
			return result.toString();
		} else {
			return state.toString();
		}
	}
	
}
