package playstate;

import java.util.ArrayList;
import java.util.Scanner;

public class Main {
	
	public static void main(String[] args) {
		PlaySpace space = new PlaySpace();
		PlayState ps = space.start();
		MinMaxHeur heur = new MinMaxHeur();
		
		Scanner sc = new Scanner(System.in);
		
		while ( ! ps.isEnd() ) {
			System.out.println(ps);
			
			PlayStep bestStep = MinMax.offer(ps, space, heur);
			ArrayList<PlayStep> ops = new ArrayList<>();
			for ( PlayStep op : space.steps() )
				if ( op.applicable(ps) )
					ops.add(op);
			
			for (int i= 0; i<ops.size(); i++) {
				System.out.print(i);
				System.out.print(ops.get(i)==bestStep?" -> ": "    ");
				System.out.println(ops.get(i));
			}
			
			int next = sc.nextInt();
			while ( next < 0 || next >= ops.size() )
				next = sc.nextInt();
			
			System.out.println(ops.get(next));
			ps = ops.get(next).apply(ps);
		}
		System.out.println(ps);
	}

}
