unit TrialAndError;

interface

  uses StateSpace;

  function basic( const stateSpace : TStateSpaceRepr ) : pointer;

implementation

  function randomOperator( const state: pointer;
    const operators : array of POperator ) : POperator;
  var
    i,app : integer;
    applicable : array of POperator;
  begin
    setLength(applicable,length(operators));
    app := 0;
    for i:= 0 to high(operators) do
      if ( operators[i]^.isApplicable(state) ) then
      begin
        applicable[app]:=operators[i];
        inc(app);
      end;
    if app = 0 then
      randomOperator := nil
    else
      randomOperator := applicable[random(app)];
  end;

  function basic( const stateSpace : TStateSpaceRepr ) : pointer;
  var state, old : pointer; op : POperator;
  begin
    state := stateSpace.initialState();
    while not stateSpace.isGoalState(state) do
    begin
      op := randomOperator( state, stateSpace.operators );
      if op <> nil then begin
        old := state;
        state := op^.apply(state);
        freeMem( old );
      end;
    end;
    if ( stateSpace.isGoalState(state) ) then
      basic := state
    else begin
      freeMem(state);
      basic := nil;
    end;
  end;

initialization
  randomize();
end.
