unit StateSpace;

interface

type

  TStateCondition =
    function( const state: pointer ) : boolean;

  TEquals =
    function( const s1, s2: pointer ) : boolean;

  TOperation =
    function( const state: pointer ) : pointer;

  TOperator = record
    isApplicable : TStateCondition;
    apply : TOperation;
  end;

  POperator = ^TOperator;

  TStateSpaceRepr = record
    initialState : function : pointer;
    isState : TStateCondition;
    isGoalState : TStateCondition;
    operators : array of POperator;
    equals : TEquals;
  end;

implementation

end.
