program Hanoi;
uses StateSpace, TrialAndError;

const count = 3;

type
  THanoiState = array[1..count] of Byte;
  PHanoiState = ^THanoiState;


function isApplicable(
  const state: PHanoiState; i,j:Integer ) : Boolean;
var ind, c : integer;
begin
  c := 1;
  while (c<=count) and (state^[c]<>i) do
    inc(c);
  if (c>count) then begin
    isApplicable := false;
    exit;
  end;
  for ind:=1 to c-1 do
    if state^[ind] = j then begin
      isApplicable := false;
      exit;
    end;
  isApplicable := true;
end;


function apply(
  const state: PHanoiState; i, j : integer ) : PHanoiState;
var ind,c : byte;
begin
  c := 1;
  while (c<=count) and (state^[c]<>i) do
    inc(c);
  apply := getMem( sizeof(THanoiState) );
  for ind:=1 to count do
    if ( ind = c ) then
      apply^[ind] := j
    else
      apply^[ind] := state^[ind];
end;


function op12App( const s : pointer ) : boolean;
begin
  op12App:=isApplicable(s,1,2)
end;

function op13App( const s : pointer ) : boolean;
begin
  op13App:=isApplicable(s,1,3)
end;

function op21App( const s : pointer ) : boolean;
begin
  op21App:=isApplicable(s,2,1)
end;

function op23App( const s : pointer ) : boolean;
begin
  op23App:=isApplicable(s,2,3)
end;

function op31App( const s : pointer ) : boolean;
begin
  op31App:=isApplicable(s,3,1)
end;

function op32App( const s : pointer ) : boolean;
begin
  op32App:=isApplicable(s,3,2)
end;


function op12( const s : pointer ) : pointer;
begin
  op12:=apply(s,1,2)
end;

function op13( const s : pointer ) : pointer;
begin
  op13:=apply(s,1,3)
end;

function op21( const s : pointer ) : pointer;
begin
  op21:=apply(s,2,1)
end;

function op23( const s : pointer ) : pointer;
begin
  op23:=apply(s,2,3)
end;

function op31( const s : pointer ) : pointer;
begin
  op31:=apply(s,3,1)
end;

function op32( const s : pointer ) : pointer;
begin
  op32:=apply(s,3,2)
end;


function equals( const s1, s2 : pointer ) : boolean;
var
  state1, state2 : PHanoiState;
  i : integer;
begin
  state1 := s1;
  state2 := s2;
  for i := 1 to count do
    if ( state2^[i] <> state1^[i] ) then begin
      equals := false;
      exit;
    end;
  equals := true;
end;


procedure print( const s : pointer );
var
  i : integer;
  strs : array[1..3] of String;
  state : PHanoiState;
begin
  state := s;
  for i := 1 to 3 do
    strs[i]:='';
  for i := 1 to count do
    strs[state^[i]]:=strs[state^[i]]+chr(48+i);
  for i := 1 to 3 do
    while length(strs[i])<count do
      strs[i]:=' '+strs[i];
  for i:=1 to 3 do
    write(strs[i],'| ');
  writeln;
end;


function isGoal( const s : pointer ) : boolean;
var
  stat : PHanoiState;
  i : integer;
begin
  stat := s;
  for i:=1 to count do
    if stat^[i]<>3 then begin
      isGoal := false;
      exit;
    end;
  isGoal := true;
end;


function initial() : pointer;
var i : integer; res : PHanoiState;
begin
  res := getMem( sizeof(THanoiState) );
  for i:=1 to count do
    res^[i]:=1;
  initial := res;
end;


const
  op1 : TOperator = ( isApplicable:@op12app; apply:@op12 );
  op2 : TOperator = ( isApplicable:@op13app; apply:@op13 );
  op3 : TOperator = ( isApplicable:@op21app; apply:@op21 );
  op4 : TOperator = ( isApplicable:@op23app; apply:@op23 );
  op5 : TOperator = ( isApplicable:@op31app; apply:@op31 );
  op6 : TOperator = ( isApplicable:@op32app; apply:@op32 );

  stateSpaceRepr : TStateSpaceRepr = (
    initialState : @initial;
    isState : nil;
    isGoalState : @isGoal;
    operators : nil;
    equals : @equals;


  );

var
  goal : PHanoiState;
begin
  setLength(stateSpaceRepr.operators,6);
  stateSpaceRepr.operators[0] := @op1;
  stateSpaceRepr.operators[1] := @op2;
  stateSpaceRepr.operators[2] := @op3;
  stateSpaceRepr.operators[3] := @op4;
  stateSpaceRepr.operators[4] := @op5;
  stateSpaceRepr.operators[5] := @op6;

  goal := TrialAndError.basic( stateSpaceRepr );

  if ( goal <> nil ) then
  begin
    print(goal);
    freeMem(goal);
  end;

end.
