unit BackTrack, kiiratas;

interface

  uses StateSpace;

  type operatorList = array of POperator;

  function basic(
    const stateSpace: TStateSpaceRepr ): operatorList;

  function circleSafe(
    const stateSpace: TStateSpaceRepr ): operatorList;

implementation


  type

  PBackTrackNode = ^TBackTrackNode;
  TBackTrackNode = record
    nextOp : integer;
    state : pointer;
    parent : PBackTrackNode;
  end;


  function notFound( arr: array of PBackTrackNode;
    highIndex: integer; st : pointer; eq : TEquals ) : boolean;
  var i : integer;
  begin
    for i := 0 to highIndex do
      if eq( arr[i]^.state, st) then begin
        notFound := false;
        exit;
      end;
    notFound := true;
  end;


  function toOperatorList(
    node : PBacktrackNode ): operatorList;
  begin

  end;

  function basic( const stateSpace: TStateSpaceRepr ): operatorList;
  var
    lastNode, tempNode: PBackTrackNode;
    newState: pointer;
    op: TOperator;
  begin
    lastNode:=getMem( sizeof(PBackTrackNode) );
    lastNode^.nextOp:= 0;
    lastNode^.state:= stateSpace.initialState();
    lastNode^.parent:= nil;
    while (lastNode<>nil) and
      not (stateSpace.isGoalState(lastNode^.state)) do
    begin
      if lastNode^.nextOp <= high(stateSpace.operators) then
      begin
        op := stateSpace.operators[lastNode^.nextOp]^;
        inc(lastNode^.nextOp);
        if op.isApplicable(lastNode^.state) then
        begin
          tempNode:= getMem( sizeof(TBackTrackNode ) );
          tempNode^.nextOp:= 0;
          tempNode^.state:= op.apply(lastNode^.state);
          tempNode^.parent:= lastNode;
        end;
      end else begin
        tempNode:= lastNode^.parent;
        freemem( lastNode^.state );
        freemem( lastNode );
        lastNode:= tempNode;
      end;
    end;
    basic:= toOperatorList(lastNode);
  end;

  function circleSafe( const stateSpace: TStateSpaceRepr ): operatorList;
  begin

  end;


begin
  randomize();
end.
