from latin import *
from time import time

def get_squares(n, limit):
    counter = 0
    first = True
    pretime = time()
    for square in red_latins(n):
        if first:
            start_time = time()
            first = False
        counter += 1
        if counter == limit:
            break
    end_time = time()
    return end_time - start_time, start_time - pretime, counter


repeat = 5
n_range = [8, 10, 12]
limits = [1000, 10000, 100000, 1000000]

for n in n_range:
    for limit in limits:
        print("n={}, limit={}".format(n, limit))
        average = 0
        for i in range(repeat):
            #print("iteration {}".format(i))
            runtime, pretime, counter = get_squares(n, limit)
            average += runtime
        average /= repeat
        print("Average runtime to generate {} squares of size {}: {}s".format(counter, n, average))
        print("Time to find first square: {}s".format(pretime))
        print("---------")
    print("##################")
