from latin import *
from time import time

############
max_number_of_orbits = 100
n = 6
starting_parity = [-1]
os_limit = 100000
############

start_time = time()

orbits = []
for square in red_latins(n):
    if len(orbits) == max_number_of_orbits:
        break
    if parity(square) in starting_parity:
        new_orbit = True
        t_square = tuple_square(square)
        for orbit in orbits:
            if t_square in orbit:
                new_orbit = False
                break
        if new_orbit:
            try:
                orbits.append(h_images_orbit(square, os_limit))
            except OrbitSizeException:
                print("Orbit too big!")

end_time = time()

summ = 0
print("Number of orbits: {}".format(len(orbits)))
for orbit in orbits:
    summ += len(orbit)

print("Sum: {}".format(summ))

for orbit in orbits:
    odd = 0
    even = 0
    for square in orbit:
        if parity(square) == -1:
            odd += 1
        else:
            even += 1
    print("Length: {}, Odd: {}, Even: {}".format(len(orbit), odd, even))

print("Time elapsed: {}s".format(end_time - start_time))

counter = 0
print("Non-image squares:")
for square in red_latins(n):
    t_square = tuple_square(square)
    found = False
    for orbit in orbits:
        if t_square in orbit:
            found = True
            break
    if not found:
        counter += 1
        print(counter)
        print_square(t_square)
        print("-------------")